/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitConnectionInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitStatsInner;
import com.azure.resourcemanager.network.fluent.models.PeerExpressRouteCircuitConnectionInner;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRouteConnectionId;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ExpressRouteCircuitPeeringInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteCircuitPeeringInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.peeringType")
    private ExpressRoutePeeringType peeringType;
    @JsonProperty(value="properties.state")
    private ExpressRoutePeeringState state;
    @JsonProperty(value="properties.azureASN")
    private Integer azureAsn;
    @JsonProperty(value="properties.peerASN")
    private Long peerAsn;
    @JsonProperty(value="properties.primaryPeerAddressPrefix")
    private String primaryPeerAddressPrefix;
    @JsonProperty(value="properties.secondaryPeerAddressPrefix")
    private String secondaryPeerAddressPrefix;
    @JsonProperty(value="properties.primaryAzurePort")
    private String primaryAzurePort;
    @JsonProperty(value="properties.secondaryAzurePort")
    private String secondaryAzurePort;
    @JsonProperty(value="properties.sharedKey")
    private String sharedKey;
    @JsonProperty(value="properties.vlanId")
    private Integer vlanId;
    @JsonProperty(value="properties.microsoftPeeringConfig")
    private ExpressRouteCircuitPeeringConfig microsoftPeeringConfig;
    @JsonProperty(value="properties.stats")
    private ExpressRouteCircuitStatsInner stats;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.gatewayManagerEtag")
    private String gatewayManagerEtag;
    @JsonProperty(value="properties.lastModifiedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String lastModifiedBy;
    @JsonProperty(value="properties.routeFilter")
    private SubResource routeFilter;
    @JsonProperty(value="properties.ipv6PeeringConfig")
    private Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig;
    @JsonProperty(value="properties.expressRouteConnection")
    private ExpressRouteConnectionId expressRouteConnection;
    @JsonProperty(value="properties.connections")
    private List<ExpressRouteCircuitConnectionInner> connections;
    @JsonProperty(value="properties.peeredConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PeerExpressRouteCircuitConnectionInner> peeredConnections;

    public String name() {
        return this.name;
    }

    public ExpressRouteCircuitPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ExpressRoutePeeringType peeringType() {
        return this.peeringType;
    }

    public ExpressRouteCircuitPeeringInner withPeeringType(ExpressRoutePeeringType peeringType) {
        this.peeringType = peeringType;
        return this;
    }

    public ExpressRoutePeeringState state() {
        return this.state;
    }

    public ExpressRouteCircuitPeeringInner withState(ExpressRoutePeeringState state) {
        this.state = state;
        return this;
    }

    public Integer azureAsn() {
        return this.azureAsn;
    }

    public ExpressRouteCircuitPeeringInner withAzureAsn(Integer azureAsn) {
        this.azureAsn = azureAsn;
        return this;
    }

    public Long peerAsn() {
        return this.peerAsn;
    }

    public ExpressRouteCircuitPeeringInner withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    public String primaryPeerAddressPrefix() {
        return this.primaryPeerAddressPrefix;
    }

    public ExpressRouteCircuitPeeringInner withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        this.primaryPeerAddressPrefix = primaryPeerAddressPrefix;
        return this;
    }

    public String secondaryPeerAddressPrefix() {
        return this.secondaryPeerAddressPrefix;
    }

    public ExpressRouteCircuitPeeringInner withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        this.secondaryPeerAddressPrefix = secondaryPeerAddressPrefix;
        return this;
    }

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public ExpressRouteCircuitPeeringInner withPrimaryAzurePort(String primaryAzurePort) {
        this.primaryAzurePort = primaryAzurePort;
        return this;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public ExpressRouteCircuitPeeringInner withSecondaryAzurePort(String secondaryAzurePort) {
        this.secondaryAzurePort = secondaryAzurePort;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public ExpressRouteCircuitPeeringInner withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public Integer vlanId() {
        return this.vlanId;
    }

    public ExpressRouteCircuitPeeringInner withVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.microsoftPeeringConfig;
    }

    public ExpressRouteCircuitPeeringInner withMicrosoftPeeringConfig(ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        this.microsoftPeeringConfig = microsoftPeeringConfig;
        return this;
    }

    public ExpressRouteCircuitStatsInner stats() {
        return this.stats;
    }

    public ExpressRouteCircuitPeeringInner withStats(ExpressRouteCircuitStatsInner stats) {
        this.stats = stats;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String gatewayManagerEtag() {
        return this.gatewayManagerEtag;
    }

    public ExpressRouteCircuitPeeringInner withGatewayManagerEtag(String gatewayManagerEtag) {
        this.gatewayManagerEtag = gatewayManagerEtag;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public SubResource routeFilter() {
        return this.routeFilter;
    }

    public ExpressRouteCircuitPeeringInner withRouteFilter(SubResource routeFilter) {
        this.routeFilter = routeFilter;
        return this;
    }

    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return this.ipv6PeeringConfig;
    }

    public ExpressRouteCircuitPeeringInner withIpv6PeeringConfig(Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig) {
        this.ipv6PeeringConfig = ipv6PeeringConfig;
        return this;
    }

    public ExpressRouteConnectionId expressRouteConnection() {
        return this.expressRouteConnection;
    }

    public ExpressRouteCircuitPeeringInner withExpressRouteConnection(ExpressRouteConnectionId expressRouteConnection) {
        this.expressRouteConnection = expressRouteConnection;
        return this;
    }

    public List<ExpressRouteCircuitConnectionInner> connections() {
        return this.connections;
    }

    public ExpressRouteCircuitPeeringInner withConnections(List<ExpressRouteCircuitConnectionInner> connections) {
        this.connections = connections;
        return this;
    }

    public List<PeerExpressRouteCircuitConnectionInner> peeredConnections() {
        return this.peeredConnections;
    }

    public void validate() {
        if (this.microsoftPeeringConfig() != null) {
            this.microsoftPeeringConfig().validate();
        }
        if (this.stats() != null) {
            this.stats().validate();
        }
        if (this.ipv6PeeringConfig() != null) {
            this.ipv6PeeringConfig().validate();
        }
        if (this.expressRouteConnection() != null) {
            this.expressRouteConnection().validate();
        }
        if (this.connections() != null) {
            this.connections().forEach(e -> e.validate());
        }
        if (this.peeredConnections() != null) {
            this.peeredConnections().forEach(e -> e.validate());
        }
    }
}

