/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class FlowLogInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FlowLogInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.targetResourceId")
    private String targetResourceId;
    @JsonProperty(value="properties.targetResourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String targetResourceGuid;
    @JsonProperty(value="properties.storageId")
    private String storageId;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.retentionPolicy")
    private RetentionPolicyParameters retentionPolicy;
    @JsonProperty(value="properties.format")
    private FlowLogFormatParameters format;
    @JsonProperty(value="properties.flowAnalyticsConfiguration")
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String targetResourceGuid() {
        return this.targetResourceGuid;
    }

    public String storageId() {
        return this.storageId;
    }

    public FlowLogInner withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public FlowLogInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    public FlowLogInner withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.format;
    }

    public FlowLogInner withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogInner withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public FlowLogInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
    }
}

