/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualApplianceNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceSkuProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class NetworkVirtualApplianceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkVirtualApplianceInner.class);
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.nvaSku")
    private VirtualApplianceSkuProperties nvaSku;
    @JsonProperty(value="properties.bootStrapConfigurationBlobs")
    private List<String> bootStrapConfigurationBlobs;
    @JsonProperty(value="properties.virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="properties.cloudInitConfigurationBlobs")
    private List<String> cloudInitConfigurationBlobs;
    @JsonProperty(value="properties.cloudInitConfiguration")
    private String cloudInitConfiguration;
    @JsonProperty(value="properties.virtualApplianceAsn")
    private Long virtualApplianceAsn;
    @JsonProperty(value="properties.virtualApplianceNics", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualApplianceNicProperties> virtualApplianceNics;
    @JsonProperty(value="properties.virtualApplianceSites", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> virtualApplianceSites;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public NetworkVirtualApplianceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public VirtualApplianceSkuProperties nvaSku() {
        return this.nvaSku;
    }

    public NetworkVirtualApplianceInner withNvaSku(VirtualApplianceSkuProperties nvaSku) {
        this.nvaSku = nvaSku;
        return this;
    }

    public List<String> bootStrapConfigurationBlobs() {
        return this.bootStrapConfigurationBlobs;
    }

    public NetworkVirtualApplianceInner withBootStrapConfigurationBlobs(List<String> bootStrapConfigurationBlobs) {
        this.bootStrapConfigurationBlobs = bootStrapConfigurationBlobs;
        return this;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public NetworkVirtualApplianceInner withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<String> cloudInitConfigurationBlobs() {
        return this.cloudInitConfigurationBlobs;
    }

    public NetworkVirtualApplianceInner withCloudInitConfigurationBlobs(List<String> cloudInitConfigurationBlobs) {
        this.cloudInitConfigurationBlobs = cloudInitConfigurationBlobs;
        return this;
    }

    public String cloudInitConfiguration() {
        return this.cloudInitConfiguration;
    }

    public NetworkVirtualApplianceInner withCloudInitConfiguration(String cloudInitConfiguration) {
        this.cloudInitConfiguration = cloudInitConfiguration;
        return this;
    }

    public Long virtualApplianceAsn() {
        return this.virtualApplianceAsn;
    }

    public NetworkVirtualApplianceInner withVirtualApplianceAsn(Long virtualApplianceAsn) {
        this.virtualApplianceAsn = virtualApplianceAsn;
        return this;
    }

    public List<VirtualApplianceNicProperties> virtualApplianceNics() {
        return this.virtualApplianceNics;
    }

    public List<SubResource> virtualApplianceSites() {
        return this.virtualApplianceSites;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public NetworkVirtualApplianceInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.nvaSku() != null) {
            this.nvaSku().validate();
        }
        if (this.virtualApplianceNics() != null) {
            this.virtualApplianceNics().forEach(e -> e.validate());
        }
    }
}

