/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.models.DdosSettings;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddressSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PublicIpAddressInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PublicIpAddressInner.class);
    @JsonProperty(value="sku")
    private PublicIpAddressSku sku;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.publicIPAllocationMethod")
    private IpAllocationMethod publicIpAllocationMethod;
    @JsonProperty(value="properties.publicIPAddressVersion")
    private IpVersion publicIpAddressVersion;
    @JsonProperty(value="properties.ipConfiguration", access=JsonProperty.Access.WRITE_ONLY)
    private IpConfigurationInner ipConfiguration;
    @JsonProperty(value="properties.dnsSettings")
    private PublicIpAddressDnsSettings dnsSettings;
    @JsonProperty(value="properties.ddosSettings")
    private DdosSettings ddosSettings;
    @JsonProperty(value="properties.ipTags")
    private List<IpTag> ipTags;
    @JsonProperty(value="properties.ipAddress")
    private String ipAddress;
    @JsonProperty(value="properties.publicIPPrefix")
    private SubResource publicIpPrefix;
    @JsonProperty(value="properties.idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public PublicIpAddressSku sku() {
        return this.sku;
    }

    public PublicIpAddressInner withSku(PublicIpAddressSku sku) {
        this.sku = sku;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public PublicIpAddressInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public IpAllocationMethod publicIpAllocationMethod() {
        return this.publicIpAllocationMethod;
    }

    public PublicIpAddressInner withPublicIpAllocationMethod(IpAllocationMethod publicIpAllocationMethod) {
        this.publicIpAllocationMethod = publicIpAllocationMethod;
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public PublicIpAddressInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public IpConfigurationInner ipConfiguration() {
        return this.ipConfiguration;
    }

    public PublicIpAddressDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public PublicIpAddressInner withDnsSettings(PublicIpAddressDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public DdosSettings ddosSettings() {
        return this.ddosSettings;
    }

    public PublicIpAddressInner withDdosSettings(DdosSettings ddosSettings) {
        this.ddosSettings = ddosSettings;
        return this;
    }

    public List<IpTag> ipTags() {
        return this.ipTags;
    }

    public PublicIpAddressInner withIpTags(List<IpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public PublicIpAddressInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public PublicIpAddressInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public PublicIpAddressInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public PublicIpAddressInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.ipConfiguration() != null) {
            this.ipConfiguration().validate();
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ddosSettings() != null) {
            this.ddosSettings().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
    }
}

