/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class VirtualNetworkPeeringInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkPeeringInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.allowVirtualNetworkAccess")
    private Boolean allowVirtualNetworkAccess;
    @JsonProperty(value="properties.allowForwardedTraffic")
    private Boolean allowForwardedTraffic;
    @JsonProperty(value="properties.allowGatewayTransit")
    private Boolean allowGatewayTransit;
    @JsonProperty(value="properties.useRemoteGateways")
    private Boolean useRemoteGateways;
    @JsonProperty(value="properties.remoteVirtualNetwork")
    private SubResource remoteVirtualNetwork;
    @JsonProperty(value="properties.remoteAddressSpace")
    private AddressSpace remoteAddressSpace;
    @JsonProperty(value="properties.peeringState")
    private VirtualNetworkPeeringState peeringState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public VirtualNetworkPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public Boolean allowVirtualNetworkAccess() {
        return this.allowVirtualNetworkAccess;
    }

    public VirtualNetworkPeeringInner withAllowVirtualNetworkAccess(Boolean allowVirtualNetworkAccess) {
        this.allowVirtualNetworkAccess = allowVirtualNetworkAccess;
        return this;
    }

    public Boolean allowForwardedTraffic() {
        return this.allowForwardedTraffic;
    }

    public VirtualNetworkPeeringInner withAllowForwardedTraffic(Boolean allowForwardedTraffic) {
        this.allowForwardedTraffic = allowForwardedTraffic;
        return this;
    }

    public Boolean allowGatewayTransit() {
        return this.allowGatewayTransit;
    }

    public VirtualNetworkPeeringInner withAllowGatewayTransit(Boolean allowGatewayTransit) {
        this.allowGatewayTransit = allowGatewayTransit;
        return this;
    }

    public Boolean useRemoteGateways() {
        return this.useRemoteGateways;
    }

    public VirtualNetworkPeeringInner withUseRemoteGateways(Boolean useRemoteGateways) {
        this.useRemoteGateways = useRemoteGateways;
        return this;
    }

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public VirtualNetworkPeeringInner withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public AddressSpace remoteAddressSpace() {
        return this.remoteAddressSpace;
    }

    public VirtualNetworkPeeringInner withRemoteAddressSpace(AddressSpace remoteAddressSpace) {
        this.remoteAddressSpace = remoteAddressSpace;
        return this;
    }

    public VirtualNetworkPeeringState peeringState() {
        return this.peeringState;
    }

    public VirtualNetworkPeeringInner withPeeringState(VirtualNetworkPeeringState peeringState) {
        this.peeringState = peeringState;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.remoteAddressSpace() != null) {
            this.remoteAddressSpace().validate();
        }
    }
}

