/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ExpressRouteCrossConnectionPeeringsClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionImpl;
import com.azure.resourcemanager.network.implementation.Ipv6PeeringConfigImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnection;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeering;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import reactor.core.publisher.Mono;

class ExpressRouteCrossConnectionPeeringImpl
extends CreatableUpdatableImpl<ExpressRouteCrossConnectionPeering, ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeeringImpl>
implements ExpressRouteCrossConnectionPeering,
ExpressRouteCrossConnectionPeering.Definition,
ExpressRouteCrossConnectionPeering.Update {
    private final ExpressRouteCrossConnectionPeeringsClient client;
    private final ExpressRouteCrossConnection parent;

    ExpressRouteCrossConnectionPeeringImpl(ExpressRouteCrossConnectionImpl parent, ExpressRouteCrossConnectionPeeringInner innerObject, ExpressRoutePeeringType type) {
        super(type.toString(), (Object)innerObject);
        this.client = ((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getExpressRouteCrossConnectionPeerings();
        this.parent = parent;
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withPeeringType(type);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withAdvertisedPublicPrefixes(String publicPrefix) {
        this.ensureMicrosoftPeeringConfig().withAdvertisedPublicPrefixes(Arrays.asList(publicPrefix));
        return this;
    }

    private ExpressRouteCircuitPeeringConfig ensureMicrosoftPeeringConfig() {
        if (((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig() == null) {
            ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withMicrosoftPeeringConfig(new ExpressRouteCircuitPeeringConfig());
        }
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withPrimaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withPrimaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withSecondaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withSecondaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withVlanId(int vlanId) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withVlanId(vlanId);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withPeerAsn(long peerASN) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withPeerAsn(peerASN);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeering.DefinitionStages.WithCreate withSharedKey(String sharedKey) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withSharedKey(sharedKey);
        return this;
    }

    public Ipv6PeeringConfigImpl defineIpv6Config() {
        return new Ipv6PeeringConfigImpl(new Ipv6ExpressRouteCircuitPeeringConfig(), this);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withoutIpv6Config() {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withIpv6PeeringConfig(null);
        return this;
    }

    ExpressRouteCrossConnectionPeeringImpl attachIpv6Config(Ipv6PeeringConfigImpl ipv6PeeringConfig) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withIpv6PeeringConfig((Ipv6ExpressRouteCircuitPeeringConfig)ipv6PeeringConfig.innerModel());
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withCustomerAsn(int customerASN) {
        this.ensureMicrosoftPeeringConfig().withCustomerAsn(customerASN);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withRoutingRegistryName(String routingRegistryName) {
        this.ensureMicrosoftPeeringConfig().withRoutingRegistryName(routingRegistryName);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withState(ExpressRoutePeeringState state) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).withState(state);
        return this;
    }

    protected Mono<ExpressRouteCrossConnectionPeeringInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    public boolean isInCreateMode() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).id() == null;
    }

    public Mono<ExpressRouteCrossConnectionPeering> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), (ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).map(innerModel -> {
            this.setInner(innerModel);
            this.parent.refresh();
            return this;
        });
    }

    public String id() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).id();
    }

    public NetworkManager manager() {
        return (NetworkManager)((Object)this.parent.manager());
    }

    public String resourceGroupName() {
        return this.parent.resourceGroupName();
    }

    @Override
    public ExpressRoutePeeringType peeringType() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).peeringType();
    }

    @Override
    public ExpressRoutePeeringState state() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).state();
    }

    @Override
    public int azureAsn() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).azureAsn());
    }

    @Override
    public long peerAsn() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).peerAsn());
    }

    @Override
    public String primaryPeerAddressPrefix() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).primaryPeerAddressPrefix();
    }

    @Override
    public String secondaryPeerAddressPrefix() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).secondaryPeerAddressPrefix();
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).secondaryAzurePort();
    }

    @Override
    public String sharedKey() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).sharedKey();
    }

    @Override
    public int vlanId() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).vlanId());
    }

    @Override
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).microsoftPeeringConfig();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public String gatewayManagerEtag() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).gatewayManagerEtag();
    }

    @Override
    public String lastModifiedBy() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).lastModifiedBy();
    }

    @Override
    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.innerModel())).ipv6PeeringConfig();
    }
}

