/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ExpressRouteGatewaysClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteGatewayInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteGatewayListInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExpressRouteGatewaysClientImpl
implements InnerSupportsGet<ExpressRouteGatewayInner>,
InnerSupportsDelete<Void>,
ExpressRouteGatewaysClient {
    private final ClientLogger logger = new ClientLogger(ExpressRouteGatewaysClientImpl.class);
    private final ExpressRouteGatewaysService service;
    private final NetworkManagementClientImpl client;

    ExpressRouteGatewaysClientImpl(NetworkManagementClientImpl client) {
        this.service = (ExpressRouteGatewaysService)RestProxy.create(ExpressRouteGatewaysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ExpressRouteGatewayListInner>> listBySubscriptionWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.listBySubscription(this.client.getEndpoint(), "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ExpressRouteGatewayListInner>> listBySubscriptionWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.listBySubscription(this.client.getEndpoint(), "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<ExpressRouteGatewayListInner> listBySubscriptionAsync() {
        return this.listBySubscriptionWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ExpressRouteGatewayListInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ExpressRouteGatewayListInner listBySubscription() {
        return (ExpressRouteGatewayListInner)this.listBySubscriptionAsync().block();
    }

    @Override
    public Response<ExpressRouteGatewayListInner> listBySubscriptionWithResponse(Context context) {
        return (Response)this.listBySubscriptionWithResponseAsync(context).block();
    }

    @Override
    public Mono<Response<ExpressRouteGatewayListInner>> listByResourceGroupWithResponseAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ExpressRouteGatewayListInner>> listByResourceGroupWithResponseAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<ExpressRouteGatewayListInner> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithResponseAsync(resourceGroupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ExpressRouteGatewayListInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ExpressRouteGatewayListInner listByResourceGroup(String resourceGroupName) {
        return (ExpressRouteGatewayListInner)this.listByResourceGroupAsync(resourceGroupName).block();
    }

    @Override
    public Response<ExpressRouteGatewayListInner> listByResourceGroupWithResponse(String resourceGroupName, Context context) {
        return (Response)this.listByResourceGroupWithResponseAsync(resourceGroupName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (putExpressRouteGatewayParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null."));
        }
        putExpressRouteGatewayParameters.validate();
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), putExpressRouteGatewayParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (putExpressRouteGatewayParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null."));
        }
        putExpressRouteGatewayParameters.validate();
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), putExpressRouteGatewayParameters, context);
    }

    @Override
    public PollerFlux<PollResult<ExpressRouteGatewayInner>, ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExpressRouteGatewayInner.class), (Type)((Object)ExpressRouteGatewayInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ExpressRouteGatewayInner>, ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExpressRouteGatewayInner.class), (Type)((Object)ExpressRouteGatewayInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ExpressRouteGatewayInner>, ExpressRouteGatewayInner> beginCreateOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ExpressRouteGatewayInner>, ExpressRouteGatewayInner> beginCreateOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters, context).getSyncPoller();
    }

    @Override
    public Mono<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ExpressRouteGatewayInner createOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return (ExpressRouteGatewayInner)((Object)this.createOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).block());
    }

    @Override
    public ExpressRouteGatewayInner createOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, Context context) {
        return (ExpressRouteGatewayInner)((Object)this.createOrUpdateAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters, context).block());
    }

    @Override
    public Mono<Response<ExpressRouteGatewayInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ExpressRouteGatewayInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String expressRouteGatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<ExpressRouteGatewayInner> getByResourceGroupAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, expressRouteGatewayName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ExpressRouteGatewayInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ExpressRouteGatewayInner getByResourceGroup(String resourceGroupName, String expressRouteGatewayName) {
        return (ExpressRouteGatewayInner)((Object)this.getByResourceGroupAsync(resourceGroupName, expressRouteGatewayName).block());
    }

    @Override
    public Response<ExpressRouteGatewayInner> getByResourceGroupWithResponse(String resourceGroupName, String expressRouteGatewayName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, expressRouteGatewayName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String expressRouteGatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (expressRouteGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, expressRouteGatewayName, "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, expressRouteGatewayName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, expressRouteGatewayName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String expressRouteGatewayName) {
        return this.beginDeleteAsync(resourceGroupName, expressRouteGatewayName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String expressRouteGatewayName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, expressRouteGatewayName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.beginDeleteAsync(resourceGroupName, expressRouteGatewayName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, expressRouteGatewayName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String expressRouteGatewayName) {
        this.deleteAsync(resourceGroupName, expressRouteGatewayName).block();
    }

    @Override
    public void delete(String resourceGroupName, String expressRouteGatewayName, Context context) {
        this.deleteAsync(resourceGroupName, expressRouteGatewayName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface ExpressRouteGatewaysService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteGateways")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteGatewayListInner>> listBySubscription(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteGatewayListInner>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="expressRouteGatewayName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") ExpressRouteGatewayInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteGatewayInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="expressRouteGatewayName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="expressRouteGatewayName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);
    }
}

