/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkInterfaceIpConfigurationsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.NetworkInterfaceIpConfigurationListResult;
import reactor.core.publisher.Mono;

public final class NetworkInterfaceIpConfigurationsClientImpl
implements NetworkInterfaceIpConfigurationsClient {
    private final ClientLogger logger = new ClientLogger(NetworkInterfaceIpConfigurationsClientImpl.class);
    private final NetworkInterfaceIpConfigurationsService service;
    private final NetworkManagementClientImpl client;

    NetworkInterfaceIpConfigurationsClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkInterfaceIpConfigurationsService)RestProxy.create(NetworkInterfaceIpConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<NetworkInterfaceIpConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkInterfaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkInterfaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, networkInterfaceName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).value(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<NetworkInterfaceIpConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkInterfaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkInterfaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, networkInterfaceName, "2020-05-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).value(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<NetworkInterfaceIpConfigurationInner> listAsync(String resourceGroupName, String networkInterfaceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkInterfaceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<NetworkInterfaceIpConfigurationInner> listAsync(String resourceGroupName, String networkInterfaceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkInterfaceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<NetworkInterfaceIpConfigurationInner> list(String resourceGroupName, String networkInterfaceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkInterfaceName));
    }

    @Override
    public PagedIterable<NetworkInterfaceIpConfigurationInner> list(String resourceGroupName, String networkInterfaceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkInterfaceName, context));
    }

    @Override
    public Mono<Response<NetworkInterfaceIpConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkInterfaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null."));
        }
        if (ipConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, networkInterfaceName, ipConfigurationName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<NetworkInterfaceIpConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkInterfaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkInterfaceName is required and cannot be null."));
        }
        if (ipConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ipConfigurationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, networkInterfaceName, ipConfigurationName, "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<NetworkInterfaceIpConfigurationInner> getAsync(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        return this.getWithResponseAsync(resourceGroupName, networkInterfaceName, ipConfigurationName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((NetworkInterfaceIpConfigurationInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public NetworkInterfaceIpConfigurationInner get(String resourceGroupName, String networkInterfaceName, String ipConfigurationName) {
        return (NetworkInterfaceIpConfigurationInner)((Object)this.getAsync(resourceGroupName, networkInterfaceName, ipConfigurationName).block());
    }

    @Override
    public Response<NetworkInterfaceIpConfigurationInner> getWithResponse(String resourceGroupName, String networkInterfaceName, String ipConfigurationName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkInterfaceName, ipConfigurationName, context).block();
    }

    private Mono<PagedResponse<NetworkInterfaceIpConfigurationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).value(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<NetworkInterfaceIpConfigurationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).value(), ((NetworkInterfaceIpConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface NetworkInterfaceIpConfigurationsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkInterfaceIpConfigurationListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkInterfaceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/ipConfigurations/{ipConfigurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkInterfaceIpConfigurationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="networkInterfaceName") String var3, @PathParam(value="ipConfigurationName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NetworkInterfaceIpConfigurationListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

