/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.implementation.NetworkSecurityRuleImpl;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NetworkSecurityRule;
import com.azure.resourcemanager.network.models.Subnet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import reactor.core.publisher.Mono;

class NetworkSecurityGroupImpl
extends GroupableParentResourceWithTagsImpl<NetworkSecurityGroup, NetworkSecurityGroupInner, NetworkSecurityGroupImpl, NetworkManager>
implements NetworkSecurityGroup,
NetworkSecurityGroup.Definition,
NetworkSecurityGroup.Update {
    private Map<String, NetworkSecurityRule> rules;
    private Map<String, NetworkSecurityRule> defaultRules;

    NetworkSecurityGroupImpl(String name, NetworkSecurityGroupInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    protected void initializeChildrenFromInner() {
        this.rules = new TreeMap<String, NetworkSecurityRule>();
        List<SecurityRuleInner> inners = ((NetworkSecurityGroupInner)((Object)this.innerModel())).securityRules();
        if (inners != null) {
            for (SecurityRuleInner inner : inners) {
                this.rules.put(inner.name(), new NetworkSecurityRuleImpl(inner, this));
            }
        }
        this.defaultRules = new TreeMap<String, NetworkSecurityRule>();
        inners = ((NetworkSecurityGroupInner)((Object)this.innerModel())).defaultSecurityRules();
        if (inners != null) {
            for (SecurityRuleInner inner : inners) {
                this.defaultRules.put(inner.name(), new NetworkSecurityRuleImpl(inner, this));
            }
        }
    }

    @Override
    public NetworkSecurityRuleImpl updateRule(String name) {
        return (NetworkSecurityRuleImpl)this.rules.get(name);
    }

    public NetworkSecurityRuleImpl defineRule(String name) {
        SecurityRuleInner inner = new SecurityRuleInner();
        inner.withName(name);
        inner.withPriority(100);
        return new NetworkSecurityRuleImpl(inner, this);
    }

    public Mono<NetworkSecurityGroup> refreshAsync() {
        return super.refreshAsync().map(networkSecurityGroup -> {
            NetworkSecurityGroupImpl impl = (NetworkSecurityGroupImpl)networkSecurityGroup;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<NetworkSecurityGroupInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkSecurityGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<NetworkSecurityGroupInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkSecurityGroups().updateTagsAsync(this.resourceGroupName(), this.name(), ((NetworkSecurityGroupInner)((Object)this.innerModel())).tags());
    }

    @Override
    public List<Subnet> listAssociatedSubnets() {
        return Utils.listAssociatedSubnets((NetworkManager)this.myManager, ((NetworkSecurityGroupInner)((Object)this.innerModel())).subnets());
    }

    @Override
    public NetworkSecurityGroup.Update withoutRule(String name) {
        this.rules.remove(name);
        return this;
    }

    NetworkSecurityGroupImpl withRule(NetworkSecurityRuleImpl rule) {
        this.rules.put(rule.name(), rule);
        return this;
    }

    @Override
    public Map<String, NetworkSecurityRule> securityRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, NetworkSecurityRule> defaultSecurityRules() {
        return Collections.unmodifiableMap(this.defaultRules);
    }

    @Override
    public Set<String> networkInterfaceIds() {
        TreeSet<String> ids = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (((NetworkSecurityGroupInner)((Object)this.innerModel())).networkInterfaces() != null) {
            for (NetworkInterfaceInner inner : ((NetworkSecurityGroupInner)((Object)this.innerModel())).networkInterfaces()) {
                ids.add(inner.id());
            }
        }
        return Collections.unmodifiableSet(ids);
    }

    protected void beforeCreating() {
        ((NetworkSecurityGroupInner)((Object)this.innerModel())).withSecurityRules(this.innersFromWrappers(this.rules.values()));
    }

    protected Mono<NetworkSecurityGroupInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkSecurityGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkSecurityGroupInner)((Object)this.innerModel()));
    }
}

