/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.UsageInner;
import com.azure.resourcemanager.network.implementation.NetworkUsageImpl;
import com.azure.resourcemanager.network.models.NetworkUsage;
import com.azure.resourcemanager.network.models.NetworkUsages;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;

public class NetworkUsagesImpl
extends ReadableWrappersImpl<NetworkUsage, NetworkUsageImpl, UsageInner>
implements NetworkUsages {
    private final NetworkManagementClient client;

    public NetworkUsagesImpl(NetworkManagementClient client) {
        this.client = client;
    }

    public PagedIterable<NetworkUsage> listByRegion(Region region) {
        return this.listByRegion(region.name());
    }

    public PagedIterable<NetworkUsage> listByRegion(String regionName) {
        return this.wrapList(this.client.getUsages().list(regionName));
    }

    public PagedFlux<NetworkUsage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public PagedFlux<NetworkUsage> listByRegionAsync(String regionName) {
        return this.wrapPageAsync(this.client.getUsages().listAsync(regionName));
    }

    protected NetworkUsageImpl wrapModel(UsageInner usageInner) {
        if (usageInner == null) {
            return null;
        }
        return new NetworkUsageImpl(usageInner);
    }
}

