/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.VirtualNetworkGatewayConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayConnectionInner;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayConnectionImpl;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnection;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnections;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

class VirtualNetworkGatewayConnectionsImpl
extends GroupableResourcesImpl<VirtualNetworkGatewayConnection, VirtualNetworkGatewayConnectionImpl, VirtualNetworkGatewayConnectionInner, VirtualNetworkGatewayConnectionsClient, NetworkManager>
implements VirtualNetworkGatewayConnections {
    private final VirtualNetworkGatewayImpl parent;

    VirtualNetworkGatewayConnectionsImpl(VirtualNetworkGatewayImpl parent) {
        super((Object)((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getVirtualNetworkGatewayConnections(), (Manager)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    protected VirtualNetworkGatewayConnectionImpl wrapModel(String name) {
        return (VirtualNetworkGatewayConnectionImpl)((VirtualNetworkGatewayConnectionImpl)new VirtualNetworkGatewayConnectionImpl(name, this.parent, new VirtualNetworkGatewayConnectionInner()).withRegion(this.parent.regionName())).withExistingResourceGroup(this.parent.resourceGroupName());
    }

    protected VirtualNetworkGatewayConnectionImpl wrapModel(VirtualNetworkGatewayConnectionInner inner) {
        if (inner == null) {
            return null;
        }
        return new VirtualNetworkGatewayConnectionImpl(inner.name(), this.parent, inner);
    }

    public VirtualNetworkGatewayConnectionImpl define(String name) {
        return this.wrapModel(name);
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return ((VirtualNetworkGatewayConnectionsClient)this.inner()).deleteAsync(this.parent.resourceGroupName(), name);
    }

    public PagedIterable<VirtualNetworkGatewayConnection> list() {
        return new PagedIterable(this.listAsync());
    }

    public VirtualNetworkGatewayConnection getByName(String name) {
        VirtualNetworkGatewayConnectionInner inner = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGatewayConnections().getByResourceGroup(this.parent().resourceGroupName(), name);
        return new VirtualNetworkGatewayConnectionImpl(name, this.parent, inner);
    }

    public VirtualNetworkGateway parent() {
        return this.parent;
    }

    public PagedFlux<VirtualNetworkGatewayConnection> listAsync() {
        return PagedConverter.mergePagedFlux((PagedFlux)((NetworkManager)this.manager()).resourceManager().resourceGroups().listAsync(), rg -> ((VirtualNetworkGatewayConnectionsClient)this.inner()).listByResourceGroupAsync(rg.name())).mapPage(this::wrapModel);
    }

    protected Mono<VirtualNetworkGatewayConnectionInner> getInnerAsync(String resourceGroupName, String name) {
        return ((VirtualNetworkGatewayConnectionsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((VirtualNetworkGatewayConnectionsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    public Mono<VirtualNetworkGatewayConnection> getByNameAsync(String name) {
        return ((VirtualNetworkGatewayConnectionsClient)this.inner()).getByResourceGroupAsync(this.parent.resourceGroupName(), name).map(this::wrapModel);
    }
}

