/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleApplicationProtocol;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonTypeName(value="ApplicationRule")
public final class ApplicationRule
extends FirewallPolicyRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationRule.class);
    @JsonProperty(value="sourceAddresses")
    private List<String> sourceAddresses;
    @JsonProperty(value="destinationAddresses")
    private List<String> destinationAddresses;
    @JsonProperty(value="protocols")
    private List<FirewallPolicyRuleApplicationProtocol> protocols;
    @JsonProperty(value="targetFqdns")
    private List<String> targetFqdns;
    @JsonProperty(value="fqdnTags")
    private List<String> fqdnTags;
    @JsonProperty(value="sourceIpGroups")
    private List<String> sourceIpGroups;

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public ApplicationRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public ApplicationRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    public List<FirewallPolicyRuleApplicationProtocol> protocols() {
        return this.protocols;
    }

    public ApplicationRule withProtocols(List<FirewallPolicyRuleApplicationProtocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public List<String> targetFqdns() {
        return this.targetFqdns;
    }

    public ApplicationRule withTargetFqdns(List<String> targetFqdns) {
        this.targetFqdns = targetFqdns;
        return this;
    }

    public List<String> fqdnTags() {
        return this.fqdnTags;
    }

    public ApplicationRule withFqdnTags(List<String> fqdnTags) {
        this.fqdnTags = fqdnTags;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public ApplicationRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.protocols() != null) {
            this.protocols().forEach(e -> e.validate());
        }
    }
}

