/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectionState;
import com.azure.resourcemanager.network.models.ConnectivityHop;
import com.azure.resourcemanager.network.models.EvaluationState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConnectionStateSnapshot {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConnectionStateSnapshot.class);
    @JsonProperty(value="connectionState")
    private ConnectionState connectionState;
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private OffsetDateTime endTime;
    @JsonProperty(value="evaluationState")
    private EvaluationState evaluationState;
    @JsonProperty(value="avgLatencyInMs")
    private Integer avgLatencyInMs;
    @JsonProperty(value="minLatencyInMs")
    private Integer minLatencyInMs;
    @JsonProperty(value="maxLatencyInMs")
    private Integer maxLatencyInMs;
    @JsonProperty(value="probesSent")
    private Integer probesSent;
    @JsonProperty(value="probesFailed")
    private Integer probesFailed;
    @JsonProperty(value="hops", access=JsonProperty.Access.WRITE_ONLY)
    private List<ConnectivityHop> hops;

    public ConnectionState connectionState() {
        return this.connectionState;
    }

    public ConnectionStateSnapshot withConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ConnectionStateSnapshot withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public ConnectionStateSnapshot withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public EvaluationState evaluationState() {
        return this.evaluationState;
    }

    public ConnectionStateSnapshot withEvaluationState(EvaluationState evaluationState) {
        this.evaluationState = evaluationState;
        return this;
    }

    public Integer avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    public ConnectionStateSnapshot withAvgLatencyInMs(Integer avgLatencyInMs) {
        this.avgLatencyInMs = avgLatencyInMs;
        return this;
    }

    public Integer minLatencyInMs() {
        return this.minLatencyInMs;
    }

    public ConnectionStateSnapshot withMinLatencyInMs(Integer minLatencyInMs) {
        this.minLatencyInMs = minLatencyInMs;
        return this;
    }

    public Integer maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    public ConnectionStateSnapshot withMaxLatencyInMs(Integer maxLatencyInMs) {
        this.maxLatencyInMs = maxLatencyInMs;
        return this;
    }

    public Integer probesSent() {
        return this.probesSent;
    }

    public ConnectionStateSnapshot withProbesSent(Integer probesSent) {
        this.probesSent = probesSent;
        return this;
    }

    public Integer probesFailed() {
        return this.probesFailed;
    }

    public ConnectionStateSnapshot withProbesFailed(Integer probesFailed) {
        this.probesFailed = probesFailed;
        return this;
    }

    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    public void validate() {
        if (this.hops() != null) {
            this.hops().forEach(e -> e.validate());
        }
    }
}

