/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.MatchedRule;
import com.azure.resourcemanager.network.models.NetworkSecurityRulesEvaluationResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class EvaluatedNetworkSecurityGroup {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EvaluatedNetworkSecurityGroup.class);
    @JsonProperty(value="networkSecurityGroupId")
    private String networkSecurityGroupId;
    @JsonProperty(value="appliedTo")
    private String appliedTo;
    @JsonProperty(value="matchedRule")
    private MatchedRule matchedRule;
    @JsonProperty(value="rulesEvaluationResult", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult;

    public String networkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    public EvaluatedNetworkSecurityGroup withNetworkSecurityGroupId(String networkSecurityGroupId) {
        this.networkSecurityGroupId = networkSecurityGroupId;
        return this;
    }

    public String appliedTo() {
        return this.appliedTo;
    }

    public EvaluatedNetworkSecurityGroup withAppliedTo(String appliedTo) {
        this.appliedTo = appliedTo;
        return this;
    }

    public MatchedRule matchedRule() {
        return this.matchedRule;
    }

    public EvaluatedNetworkSecurityGroup withMatchedRule(MatchedRule matchedRule) {
        this.matchedRule = matchedRule;
        return this;
    }

    public List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult() {
        return this.rulesEvaluationResult;
    }

    public void validate() {
        if (this.matchedRule() != null) {
            this.matchedRule().validate();
        }
        if (this.rulesEvaluationResult() != null) {
            this.rulesEvaluationResult().forEach(e -> e.validate());
        }
    }
}

