/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class P2SConnectionConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(P2SConnectionConfiguration.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.vpnClientAddressPool")
    private AddressSpace vpnClientAddressPool;
    @JsonProperty(value="properties.routingConfiguration")
    private RoutingConfiguration routingConfiguration;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public P2SConnectionConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AddressSpace vpnClientAddressPool() {
        return this.vpnClientAddressPool;
    }

    public P2SConnectionConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        this.vpnClientAddressPool = vpnClientAddressPool;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public P2SConnectionConfiguration withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.vpnClientAddressPool() != null) {
            this.vpnClientAddressPool().validate();
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

