// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnNatRuleMapping;
import com.azure.resourcemanager.network.models.VpnNatRuleMode;
import com.azure.resourcemanager.network.models.VpnNatRuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** VpnGatewayNatRule Resource. */
@JsonFlatten
@Fluent
public class VpnGatewayNatRuleInner extends SubResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VpnGatewayNatRuleInner.class);

    /*
     * The name of the resource that is unique within a resource group. This
     * name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The provisioning state of the NAT Rule resource.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The type of NAT rule for VPN NAT.
     */
    @JsonProperty(value = "properties.type")
    private VpnNatRuleType typePropertiesType;

    /*
     * The Source NAT direction of a VPN NAT.
     */
    @JsonProperty(value = "properties.mode")
    private VpnNatRuleMode mode;

    /*
     * The private IP address internal mapping for NAT.
     */
    @JsonProperty(value = "properties.internalMappings")
    private List<VpnNatRuleMapping> internalMappings;

    /*
     * The private IP address external mapping for NAT.
     */
    @JsonProperty(value = "properties.externalMappings")
    private List<VpnNatRuleMapping> externalMappings;

    /*
     * The IP Configuration ID this NAT rule applies to.
     */
    @JsonProperty(value = "properties.ipConfigurationId")
    private String ipConfigurationId;

    /*
     * List of egress VpnSiteLinkConnections.
     */
    @JsonProperty(value = "properties.egressVpnSiteLinkConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> egressVpnSiteLinkConnections;

    /*
     * List of ingress VpnSiteLinkConnections.
     */
    @JsonProperty(value = "properties.ingressVpnSiteLinkConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> ingressVpnSiteLinkConnections;

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: The provisioning state of the NAT Rule resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the typePropertiesType property: The type of NAT rule for VPN NAT.
     *
     * @return the typePropertiesType value.
     */
    public VpnNatRuleType typePropertiesType() {
        return this.typePropertiesType;
    }

    /**
     * Set the typePropertiesType property: The type of NAT rule for VPN NAT.
     *
     * @param typePropertiesType the typePropertiesType value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withTypePropertiesType(VpnNatRuleType typePropertiesType) {
        this.typePropertiesType = typePropertiesType;
        return this;
    }

    /**
     * Get the mode property: The Source NAT direction of a VPN NAT.
     *
     * @return the mode value.
     */
    public VpnNatRuleMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The Source NAT direction of a VPN NAT.
     *
     * @param mode the mode value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withMode(VpnNatRuleMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the internalMappings property: The private IP address internal mapping for NAT.
     *
     * @return the internalMappings value.
     */
    public List<VpnNatRuleMapping> internalMappings() {
        return this.internalMappings;
    }

    /**
     * Set the internalMappings property: The private IP address internal mapping for NAT.
     *
     * @param internalMappings the internalMappings value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withInternalMappings(List<VpnNatRuleMapping> internalMappings) {
        this.internalMappings = internalMappings;
        return this;
    }

    /**
     * Get the externalMappings property: The private IP address external mapping for NAT.
     *
     * @return the externalMappings value.
     */
    public List<VpnNatRuleMapping> externalMappings() {
        return this.externalMappings;
    }

    /**
     * Set the externalMappings property: The private IP address external mapping for NAT.
     *
     * @param externalMappings the externalMappings value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withExternalMappings(List<VpnNatRuleMapping> externalMappings) {
        this.externalMappings = externalMappings;
        return this;
    }

    /**
     * Get the ipConfigurationId property: The IP Configuration ID this NAT rule applies to.
     *
     * @return the ipConfigurationId value.
     */
    public String ipConfigurationId() {
        return this.ipConfigurationId;
    }

    /**
     * Set the ipConfigurationId property: The IP Configuration ID this NAT rule applies to.
     *
     * @param ipConfigurationId the ipConfigurationId value to set.
     * @return the VpnGatewayNatRuleInner object itself.
     */
    public VpnGatewayNatRuleInner withIpConfigurationId(String ipConfigurationId) {
        this.ipConfigurationId = ipConfigurationId;
        return this;
    }

    /**
     * Get the egressVpnSiteLinkConnections property: List of egress VpnSiteLinkConnections.
     *
     * @return the egressVpnSiteLinkConnections value.
     */
    public List<SubResource> egressVpnSiteLinkConnections() {
        return this.egressVpnSiteLinkConnections;
    }

    /**
     * Get the ingressVpnSiteLinkConnections property: List of ingress VpnSiteLinkConnections.
     *
     * @return the ingressVpnSiteLinkConnections value.
     */
    public List<SubResource> ingressVpnSiteLinkConnections() {
        return this.ingressVpnSiteLinkConnections;
    }

    /** {@inheritDoc} */
    @Override
    public VpnGatewayNatRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (internalMappings() != null) {
            internalMappings().forEach(e -> e.validate());
        }
        if (externalMappings() != null) {
            externalMappings().forEach(e -> e.validate());
        }
    }
}
