/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallIpConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpGroups;
import com.azure.resourcemanager.network.models.AzureFirewallNatRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallSku;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.HubIpAddresses;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class AzureFirewallInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallInner.class);
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.applicationRuleCollections")
    private List<AzureFirewallApplicationRuleCollection> applicationRuleCollections;
    @JsonProperty(value="properties.natRuleCollections")
    private List<AzureFirewallNatRuleCollection> natRuleCollections;
    @JsonProperty(value="properties.networkRuleCollections")
    private List<AzureFirewallNetworkRuleCollection> networkRuleCollections;
    @JsonProperty(value="properties.ipConfigurations")
    private List<AzureFirewallIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.managementIpConfiguration")
    private AzureFirewallIpConfiguration managementIpConfiguration;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.threatIntelMode")
    private AzureFirewallThreatIntelMode threatIntelMode;
    @JsonProperty(value="properties.virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="properties.firewallPolicy")
    private SubResource firewallPolicy;
    @JsonProperty(value="properties.hubIPAddresses")
    private HubIpAddresses hubIpAddresses;
    @JsonProperty(value="properties.ipGroups", access=JsonProperty.Access.WRITE_ONLY)
    private List<AzureFirewallIpGroups> ipGroups;
    @JsonProperty(value="properties.sku")
    private AzureFirewallSku sku;
    @JsonProperty(value="properties.additionalProperties")
    private Map<String, String> additionalProperties;
    @JsonProperty(value="id")
    private String id;

    public List<String> zones() {
        return this.zones;
    }

    public AzureFirewallInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<AzureFirewallApplicationRuleCollection> applicationRuleCollections() {
        return this.applicationRuleCollections;
    }

    public AzureFirewallInner withApplicationRuleCollections(List<AzureFirewallApplicationRuleCollection> applicationRuleCollections) {
        this.applicationRuleCollections = applicationRuleCollections;
        return this;
    }

    public List<AzureFirewallNatRuleCollection> natRuleCollections() {
        return this.natRuleCollections;
    }

    public AzureFirewallInner withNatRuleCollections(List<AzureFirewallNatRuleCollection> natRuleCollections) {
        this.natRuleCollections = natRuleCollections;
        return this;
    }

    public List<AzureFirewallNetworkRuleCollection> networkRuleCollections() {
        return this.networkRuleCollections;
    }

    public AzureFirewallInner withNetworkRuleCollections(List<AzureFirewallNetworkRuleCollection> networkRuleCollections) {
        this.networkRuleCollections = networkRuleCollections;
        return this;
    }

    public List<AzureFirewallIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public AzureFirewallInner withIpConfigurations(List<AzureFirewallIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public AzureFirewallIpConfiguration managementIpConfiguration() {
        return this.managementIpConfiguration;
    }

    public AzureFirewallInner withManagementIpConfiguration(AzureFirewallIpConfiguration managementIpConfiguration) {
        this.managementIpConfiguration = managementIpConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.threatIntelMode;
    }

    public AzureFirewallInner withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        this.threatIntelMode = threatIntelMode;
        return this;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public AzureFirewallInner withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public SubResource firewallPolicy() {
        return this.firewallPolicy;
    }

    public AzureFirewallInner withFirewallPolicy(SubResource firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        return this;
    }

    public HubIpAddresses hubIpAddresses() {
        return this.hubIpAddresses;
    }

    public AzureFirewallInner withHubIpAddresses(HubIpAddresses hubIpAddresses) {
        this.hubIpAddresses = hubIpAddresses;
        return this;
    }

    public List<AzureFirewallIpGroups> ipGroups() {
        return this.ipGroups;
    }

    public AzureFirewallSku sku() {
        return this.sku;
    }

    public AzureFirewallInner withSku(AzureFirewallSku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    public AzureFirewallInner withAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public String id() {
        return this.id;
    }

    public AzureFirewallInner withId(String id) {
        this.id = id;
        return this;
    }

    public AzureFirewallInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AzureFirewallInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.applicationRuleCollections() != null) {
            this.applicationRuleCollections().forEach(e -> e.validate());
        }
        if (this.natRuleCollections() != null) {
            this.natRuleCollections().forEach(e -> e.validate());
        }
        if (this.networkRuleCollections() != null) {
            this.networkRuleCollections().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.managementIpConfiguration() != null) {
            this.managementIpConfiguration().validate();
        }
        if (this.hubIpAddresses() != null) {
            this.hubIpAddresses().validate();
        }
        if (this.ipGroups() != null) {
            this.ipGroups().forEach(e -> e.validate());
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

