/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringId;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class ExpressRouteConnectionInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteConnectionInner.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.expressRouteCircuitPeering")
    private ExpressRouteCircuitPeeringId expressRouteCircuitPeering;
    @JsonProperty(value="properties.authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="properties.routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="properties.enableInternetSecurity")
    private Boolean enableInternetSecurity;
    @JsonProperty(value="properties.expressRouteGatewayBypass")
    private Boolean expressRouteGatewayBypass;
    @JsonProperty(value="properties.routingConfiguration")
    private RoutingConfiguration routingConfiguration;

    public String name() {
        return this.name;
    }

    public ExpressRouteConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ExpressRouteCircuitPeeringId expressRouteCircuitPeering() {
        return this.expressRouteCircuitPeering;
    }

    public ExpressRouteConnectionInner withExpressRouteCircuitPeering(ExpressRouteCircuitPeeringId expressRouteCircuitPeering) {
        this.expressRouteCircuitPeering = expressRouteCircuitPeering;
        return this;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public ExpressRouteConnectionInner withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public ExpressRouteConnectionInner withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public ExpressRouteConnectionInner withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public ExpressRouteConnectionInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public ExpressRouteConnectionInner withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public ExpressRouteConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ExpressRouteConnectionInner"));
        }
        if (this.expressRouteCircuitPeering() != null) {
            this.expressRouteCircuitPeering().validate();
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

