/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionInner;
import com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ExpressRouteGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.autoScaleConfiguration")
    private ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration;
    @JsonProperty(value="properties.expressRouteConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteConnectionInner> expressRouteConnections;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.virtualHub")
    private VirtualHubId virtualHub;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.autoScaleConfiguration;
    }

    public ExpressRouteGatewayInner withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        this.autoScaleConfiguration = autoScaleConfiguration;
        return this;
    }

    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.expressRouteConnections;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VirtualHubId virtualHub() {
        return this.virtualHub;
    }

    public ExpressRouteGatewayInner withVirtualHub(VirtualHubId virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public ExpressRouteGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.autoScaleConfiguration() != null) {
            this.autoScaleConfiguration().validate();
        }
        if (this.expressRouteConnections() != null) {
            this.expressRouteConnections().forEach(e -> e.validate());
        }
        if (this.virtualHub() != null) {
            this.virtualHub().validate();
        }
    }
}

