/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancerSku;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class LoadBalancerInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LoadBalancerInner.class);
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="sku")
    private LoadBalancerSku sku;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.frontendIPConfigurations")
    private List<FrontendIpConfigurationInner> frontendIpConfigurations;
    @JsonProperty(value="properties.backendAddressPools")
    private List<BackendAddressPoolInner> backendAddressPools;
    @JsonProperty(value="properties.loadBalancingRules")
    private List<LoadBalancingRuleInner> loadBalancingRules;
    @JsonProperty(value="properties.probes")
    private List<ProbeInner> probes;
    @JsonProperty(value="properties.inboundNatRules")
    private List<InboundNatRuleInner> inboundNatRules;
    @JsonProperty(value="properties.inboundNatPools")
    private List<InboundNatPool> inboundNatPools;
    @JsonProperty(value="properties.outboundRules")
    private List<OutboundRuleInner> outboundRules;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public LoadBalancerInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public LoadBalancerSku sku() {
        return this.sku;
    }

    public LoadBalancerInner withSku(LoadBalancerSku sku) {
        this.sku = sku;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<FrontendIpConfigurationInner> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    public LoadBalancerInner withFrontendIpConfigurations(List<FrontendIpConfigurationInner> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    public List<BackendAddressPoolInner> backendAddressPools() {
        return this.backendAddressPools;
    }

    public LoadBalancerInner withBackendAddressPools(List<BackendAddressPoolInner> backendAddressPools) {
        this.backendAddressPools = backendAddressPools;
        return this;
    }

    public List<LoadBalancingRuleInner> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public LoadBalancerInner withLoadBalancingRules(List<LoadBalancingRuleInner> loadBalancingRules) {
        this.loadBalancingRules = loadBalancingRules;
        return this;
    }

    public List<ProbeInner> probes() {
        return this.probes;
    }

    public LoadBalancerInner withProbes(List<ProbeInner> probes) {
        this.probes = probes;
        return this;
    }

    public List<InboundNatRuleInner> inboundNatRules() {
        return this.inboundNatRules;
    }

    public LoadBalancerInner withInboundNatRules(List<InboundNatRuleInner> inboundNatRules) {
        this.inboundNatRules = inboundNatRules;
        return this;
    }

    public List<InboundNatPool> inboundNatPools() {
        return this.inboundNatPools;
    }

    public LoadBalancerInner withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        this.inboundNatPools = inboundNatPools;
        return this;
    }

    public List<OutboundRuleInner> outboundRules() {
        return this.outboundRules;
    }

    public LoadBalancerInner withOutboundRules(List<OutboundRuleInner> outboundRules) {
        this.outboundRules = outboundRules;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public LoadBalancerInner withId(String id) {
        this.id = id;
        return this;
    }

    public LoadBalancerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LoadBalancerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.frontendIpConfigurations() != null) {
            this.frontendIpConfigurations().forEach(e -> e.validate());
        }
        if (this.backendAddressPools() != null) {
            this.backendAddressPools().forEach(e -> e.validate());
        }
        if (this.loadBalancingRules() != null) {
            this.loadBalancingRules().forEach(e -> e.validate());
        }
        if (this.probes() != null) {
            this.probes().forEach(e -> e.validate());
        }
        if (this.inboundNatRules() != null) {
            this.inboundNatRules().forEach(e -> e.validate());
        }
        if (this.inboundNatPools() != null) {
            this.inboundNatPools().forEach(e -> e.validate());
        }
        if (this.outboundRules() != null) {
            this.outboundRules().forEach(e -> e.validate());
        }
    }
}

