/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceTapConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceInner;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.NetworkInterfaceDnsSettings;
import com.azure.resourcemanager.network.models.NetworkInterfaceMigrationPhase;
import com.azure.resourcemanager.network.models.NetworkInterfaceNicType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class NetworkInterfaceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkInterfaceInner.class);
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualMachine", access=JsonProperty.Access.WRITE_ONLY)
    private SubResource virtualMachine;
    @JsonProperty(value="properties.networkSecurityGroup")
    private NetworkSecurityGroupInner networkSecurityGroup;
    @JsonProperty(value="properties.privateEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointInner privateEndpoint;
    @JsonProperty(value="properties.ipConfigurations")
    private List<NetworkInterfaceIpConfigurationInner> ipConfigurations;
    @JsonProperty(value="properties.tapConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceTapConfigurationInner> tapConfigurations;
    @JsonProperty(value="properties.dnsSettings")
    private NetworkInterfaceDnsSettings dnsSettings;
    @JsonProperty(value="properties.macAddress", access=JsonProperty.Access.WRITE_ONLY)
    private String macAddress;
    @JsonProperty(value="properties.primary", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean primary;
    @JsonProperty(value="properties.enableAcceleratedNetworking")
    private Boolean enableAcceleratedNetworking;
    @JsonProperty(value="properties.enableIPForwarding")
    private Boolean enableIpForwarding;
    @JsonProperty(value="properties.hostedWorkloads", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> hostedWorkloads;
    @JsonProperty(value="properties.dscpConfiguration", access=JsonProperty.Access.WRITE_ONLY)
    private SubResource dscpConfiguration;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.nicType")
    private NetworkInterfaceNicType nicType;
    @JsonProperty(value="properties.privateLinkService")
    private PrivateLinkServiceInner privateLinkService;
    @JsonProperty(value="properties.migrationPhase")
    private NetworkInterfaceMigrationPhase migrationPhase;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public NetworkInterfaceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public SubResource virtualMachine() {
        return this.virtualMachine;
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public NetworkInterfaceInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public PrivateEndpointInner privateEndpoint() {
        return this.privateEndpoint;
    }

    public List<NetworkInterfaceIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public NetworkInterfaceInner withIpConfigurations(List<NetworkInterfaceIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public List<NetworkInterfaceTapConfigurationInner> tapConfigurations() {
        return this.tapConfigurations;
    }

    public NetworkInterfaceDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public NetworkInterfaceInner withDnsSettings(NetworkInterfaceDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public Boolean primary() {
        return this.primary;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public NetworkInterfaceInner withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public NetworkInterfaceInner withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public List<String> hostedWorkloads() {
        return this.hostedWorkloads;
    }

    public SubResource dscpConfiguration() {
        return this.dscpConfiguration;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkInterfaceNicType nicType() {
        return this.nicType;
    }

    public NetworkInterfaceInner withNicType(NetworkInterfaceNicType nicType) {
        this.nicType = nicType;
        return this;
    }

    public PrivateLinkServiceInner privateLinkService() {
        return this.privateLinkService;
    }

    public NetworkInterfaceInner withPrivateLinkService(PrivateLinkServiceInner privateLinkService) {
        this.privateLinkService = privateLinkService;
        return this;
    }

    public NetworkInterfaceMigrationPhase migrationPhase() {
        return this.migrationPhase;
    }

    public NetworkInterfaceInner withMigrationPhase(NetworkInterfaceMigrationPhase migrationPhase) {
        this.migrationPhase = migrationPhase;
        return this;
    }

    public String id() {
        return this.id;
    }

    public NetworkInterfaceInner withId(String id) {
        this.id = id;
        return this;
    }

    public NetworkInterfaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkInterfaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.tapConfigurations() != null) {
            this.tapConfigurations().forEach(e -> e.validate());
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.privateLinkService() != null) {
            this.privateLinkService().validate();
        }
    }
}

