/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PacketCaptureResultInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PacketCaptureResultInner.class);
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.target")
    private String target;
    @JsonProperty(value="properties.bytesToCapturePerPacket")
    private Long bytesToCapturePerPacket;
    @JsonProperty(value="properties.totalBytesPerSession")
    private Long totalBytesPerSession;
    @JsonProperty(value="properties.timeLimitInSeconds")
    private Integer timeLimitInSeconds;
    @JsonProperty(value="properties.storageLocation")
    private PacketCaptureStorageLocation storageLocation;
    @JsonProperty(value="properties.filters")
    private List<PacketCaptureFilter> filters;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String etag() {
        return this.etag;
    }

    public String target() {
        return this.target;
    }

    public PacketCaptureResultInner withTarget(String target) {
        this.target = target;
        return this;
    }

    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    public PacketCaptureResultInner withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    public PacketCaptureResultInner withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    public PacketCaptureResultInner withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public PacketCaptureResultInner withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    public PacketCaptureResultInner withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.storageLocation() != null) {
            this.storageLocation().validate();
        }
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
    }
}

