/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RouteTableInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteTableInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.routes")
    private List<RouteInner> routes;
    @JsonProperty(value="properties.subnets", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubnetInner> subnets;
    @JsonProperty(value="properties.disableBgpRoutePropagation")
    private Boolean disableBgpRoutePropagation;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<RouteInner> routes() {
        return this.routes;
    }

    public RouteTableInner withRoutes(List<RouteInner> routes) {
        this.routes = routes;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    public RouteTableInner withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public String id() {
        return this.id;
    }

    public RouteTableInner withId(String id) {
        this.id = id;
        return this;
    }

    public RouteTableInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RouteTableInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
    }
}

