/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualNetworkInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkInner.class);
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.addressSpace")
    private AddressSpace addressSpace;
    @JsonProperty(value="properties.dhcpOptions")
    private DhcpOptions dhcpOptions;
    @JsonProperty(value="properties.subnets")
    private List<SubnetInner> subnets;
    @JsonProperty(value="properties.virtualNetworkPeerings")
    private List<VirtualNetworkPeeringInner> virtualNetworkPeerings;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.enableDdosProtection")
    private Boolean enableDdosProtection;
    @JsonProperty(value="properties.enableVmProtection")
    private Boolean enableVmProtection;
    @JsonProperty(value="properties.ddosProtectionPlan")
    private SubResource ddosProtectionPlan;
    @JsonProperty(value="properties.bgpCommunities")
    private VirtualNetworkBgpCommunities bgpCommunities;
    @JsonProperty(value="properties.ipAllocations")
    private List<SubResource> ipAllocations;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VirtualNetworkInner withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public DhcpOptions dhcpOptions() {
        return this.dhcpOptions;
    }

    public VirtualNetworkInner withDhcpOptions(DhcpOptions dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public VirtualNetworkInner withSubnets(List<SubnetInner> subnets) {
        this.subnets = subnets;
        return this;
    }

    public List<VirtualNetworkPeeringInner> virtualNetworkPeerings() {
        return this.virtualNetworkPeerings;
    }

    public VirtualNetworkInner withVirtualNetworkPeerings(List<VirtualNetworkPeeringInner> virtualNetworkPeerings) {
        this.virtualNetworkPeerings = virtualNetworkPeerings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean enableDdosProtection() {
        return this.enableDdosProtection;
    }

    public VirtualNetworkInner withEnableDdosProtection(Boolean enableDdosProtection) {
        this.enableDdosProtection = enableDdosProtection;
        return this;
    }

    public Boolean enableVmProtection() {
        return this.enableVmProtection;
    }

    public VirtualNetworkInner withEnableVmProtection(Boolean enableVmProtection) {
        this.enableVmProtection = enableVmProtection;
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.ddosProtectionPlan;
    }

    public VirtualNetworkInner withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        this.ddosProtectionPlan = ddosProtectionPlan;
        return this;
    }

    public VirtualNetworkBgpCommunities bgpCommunities() {
        return this.bgpCommunities;
    }

    public VirtualNetworkInner withBgpCommunities(VirtualNetworkBgpCommunities bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    public VirtualNetworkInner withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.dhcpOptions() != null) {
            this.dhcpOptions().validate();
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.virtualNetworkPeerings() != null) {
            this.virtualNetworkPeerings().forEach(e -> e.validate());
        }
        if (this.bgpCommunities() != null) {
            this.bgpCommunities().validate();
        }
    }
}

