/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.azure.resourcemanager.network.models.PolicySettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallCustomRule;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicyResourceState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class WebApplicationFirewallPolicyInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebApplicationFirewallPolicyInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.policySettings")
    private PolicySettings policySettings;
    @JsonProperty(value="properties.customRules")
    private List<WebApplicationFirewallCustomRule> customRules;
    @JsonProperty(value="properties.applicationGateways", access=JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationGatewayInner> applicationGateways;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private WebApplicationFirewallPolicyResourceState resourceState;
    @JsonProperty(value="properties.managedRules")
    private ManagedRulesDefinition managedRules;
    @JsonProperty(value="properties.httpListeners", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> httpListeners;
    @JsonProperty(value="properties.pathBasedRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> pathBasedRules;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public WebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public List<WebApplicationFirewallCustomRule> customRules() {
        return this.customRules;
    }

    public WebApplicationFirewallPolicyInner withCustomRules(List<WebApplicationFirewallCustomRule> customRules) {
        this.customRules = customRules;
        return this;
    }

    public List<ApplicationGatewayInner> applicationGateways() {
        return this.applicationGateways;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public WebApplicationFirewallPolicyResourceState resourceState() {
        return this.resourceState;
    }

    public ManagedRulesDefinition managedRules() {
        return this.managedRules;
    }

    public WebApplicationFirewallPolicyInner withManagedRules(ManagedRulesDefinition managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<SubResource> httpListeners() {
        return this.httpListeners;
    }

    public List<SubResource> pathBasedRules() {
        return this.pathBasedRules;
    }

    public String id() {
        return this.id;
    }

    public WebApplicationFirewallPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

    public WebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.customRules() != null) {
            this.customRules().forEach(e -> e.validate());
        }
        if (this.applicationGateways() != null) {
            this.applicationGateways().forEach(e -> e.validate());
        }
        if (this.managedRules() != null) {
            this.managedRules().validate();
        }
    }
}

