/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.AvailableProvidersListInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.AvailableProviders;
import com.azure.resourcemanager.network.models.AvailableProvidersListCountry;
import com.azure.resourcemanager.network.models.AvailableProvidersListParameters;
import com.azure.resourcemanager.network.models.NetworkWatcher;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class AvailableProvidersImpl
extends ExecutableImpl<AvailableProviders>
implements AvailableProviders,
AvailableProviders.Definition {
    private Map<String, AvailableProvidersListCountry> providersByCountry;
    private final NetworkWatcherImpl parent;
    private AvailableProvidersListParameters parameters = new AvailableProvidersListParameters();
    private AvailableProvidersListInner inner;

    AvailableProvidersImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public AvailableProvidersListParameters availableProvidersParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, AvailableProvidersListCountry> providersByCountry() {
        return Collections.unmodifiableMap(this.providersByCountry);
    }

    private void initializeResourcesFromInner() {
        this.providersByCountry = new TreeMap<String, AvailableProvidersListCountry>();
        List<AvailableProvidersListCountry> availableProvidersList = this.innerModel().countries();
        if (availableProvidersList != null) {
            for (AvailableProvidersListCountry resource : availableProvidersList) {
                this.providersByCountry.put(resource.countryName(), resource);
            }
        }
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public AvailableProvidersListInner innerModel() {
        return this.inner;
    }

    public Mono<AvailableProviders> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.parent().manager())).serviceClient()).getNetworkWatchers().listAvailableProvidersAsync(this.parent().resourceGroupName(), this.parent().name(), this.parameters).map(availableProvidersListInner -> {
            this.inner = availableProvidersListInner;
            this.initializeResourcesFromInner();
            return this;
        });
    }

    @Override
    public AvailableProvidersImpl withAzureLocations(String ... azureLocations) {
        this.parameters.withAzureLocations(Arrays.asList(azureLocations));
        return this;
    }

    @Override
    public AvailableProvidersImpl withAzureLocation(String azureLocation) {
        if (this.parameters.azureLocations() == null) {
            this.parameters.withAzureLocations(new ArrayList<String>());
        }
        this.parameters.azureLocations().add(azureLocation);
        return this;
    }

    @Override
    public AvailableProvidersImpl withCountry(String country) {
        this.parameters.withCountry(country);
        return this;
    }

    @Override
    public AvailableProvidersImpl withState(String state) {
        this.parameters.withState(state);
        return this;
    }

    @Override
    public AvailableProvidersImpl withCity(String city) {
        this.parameters.withCity(city);
        return this;
    }
}

