/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ExpressRouteCrossConnectionPeeringsClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionImpl;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionPeeringImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnection;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeering;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnectionPeerings;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import reactor.core.publisher.Mono;

class ExpressRouteCrossConnectionPeeringsImpl
extends IndependentChildrenImpl<ExpressRouteCrossConnectionPeering, ExpressRouteCrossConnectionPeeringImpl, ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeeringsClient, NetworkManager, ExpressRouteCrossConnection>
implements ExpressRouteCrossConnectionPeerings {
    private final ExpressRouteCrossConnectionImpl parent;

    ExpressRouteCrossConnectionPeeringsImpl(ExpressRouteCrossConnectionImpl parent) {
        super((Object)((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getExpressRouteCrossConnectionPeerings(), (Manager)((NetworkManager)parent.manager()));
        this.parent = parent;
    }

    public final PagedIterable<ExpressRouteCrossConnectionPeering> list() {
        return this.wrapList(((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).list(this.parent.resourceGroupName(), this.parent.name()));
    }

    public PagedFlux<ExpressRouteCrossConnectionPeering> listAsync() {
        return this.wrapPageAsync(((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected ExpressRouteCrossConnectionPeeringImpl wrapModel(String name) {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.fromString(name));
    }

    protected ExpressRouteCrossConnectionPeeringImpl wrapModel(ExpressRouteCrossConnectionPeeringInner inner) {
        return inner == null ? null : new ExpressRouteCrossConnectionPeeringImpl(this.parent, inner, inner.peeringType());
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl defineAzurePrivatePeering() {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.AZURE_PRIVATE_PEERING);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl defineMicrosoftPeering() {
        return new ExpressRouteCrossConnectionPeeringImpl(this.parent, new ExpressRouteCrossConnectionPeeringInner(), ExpressRoutePeeringType.MICROSOFT_PEERING);
    }

    public Mono<ExpressRouteCrossConnectionPeering> getByNameAsync(String name) {
        return ((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map(inner -> this.wrapModel((ExpressRouteCrossConnectionPeeringInner)((Object)inner)));
    }

    public ExpressRouteCrossConnectionPeering getByName(String name) {
        return (ExpressRouteCrossConnectionPeering)this.getByNameAsync(name).block();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ExpressRouteCrossConnection parent() {
        return this.parent;
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).deleteAsync(groupName, parentName, name).doOnSuccess(result -> this.parent.refresh()).then();
    }

    public Mono<ExpressRouteCrossConnectionPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).getAsync(resourceGroup, parentName, name).map(inner -> this.wrapModel((ExpressRouteCrossConnectionPeeringInner)((Object)inner)));
    }

    public PagedIterable<ExpressRouteCrossConnectionPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((ExpressRouteCrossConnectionPeeringsClient)this.innerModel()).list(resourceGroupName, parentName));
    }
}

