/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerHttpProbe;
import com.azure.resourcemanager.network.models.LoadBalancerTcpProbe;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.ProbeProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

class LoadBalancerProbeImpl
extends ChildResourceImpl<ProbeInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerTcpProbe,
LoadBalancerTcpProbe.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerTcpProbe.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerTcpProbe.Update,
LoadBalancerHttpProbe,
LoadBalancerHttpProbe.Definition<LoadBalancer.DefinitionStages.WithCreate>,
LoadBalancerHttpProbe.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerHttpProbe.Update {
    LoadBalancerProbeImpl(ProbeInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public int intervalInSeconds() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ProbeInner)((Object)this.innerModel())).intervalInSeconds());
    }

    @Override
    public int port() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ProbeInner)((Object)this.innerModel())).port());
    }

    @Override
    public int numberOfProbes() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ProbeInner)((Object)this.innerModel())).numberOfProbes());
    }

    public String name() {
        return ((ProbeInner)((Object)this.innerModel())).name();
    }

    @Override
    public ProbeProtocol protocol() {
        return ((ProbeInner)((Object)this.innerModel())).protocol();
    }

    @Override
    public String requestPath() {
        return ((ProbeInner)((Object)this.innerModel())).requestPath();
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        TreeMap<String, LoadBalancingRule> rules = new TreeMap<String, LoadBalancingRule>();
        if (((ProbeInner)((Object)this.innerModel())).loadBalancingRules() != null) {
            for (SubResource inner : ((ProbeInner)((Object)this.innerModel())).loadBalancingRules()) {
                String name = ResourceUtils.nameFromResourceId((String)inner.id());
                LoadBalancingRule rule = ((LoadBalancerImpl)this.parent()).loadBalancingRules().get(name);
                if (rule == null) continue;
                rules.put(name, rule);
            }
        }
        return Collections.unmodifiableMap(rules);
    }

    @Override
    public LoadBalancerProbeImpl withPort(int port) {
        ((ProbeInner)((Object)this.innerModel())).withPort(port);
        return this;
    }

    @Override
    public LoadBalancerProbeImpl withRequestPath(String requestPath) {
        ((ProbeInner)((Object)this.innerModel())).withRequestPath(requestPath);
        return this;
    }

    @Override
    public LoadBalancerProbeImpl withIntervalInSeconds(int seconds) {
        ((ProbeInner)((Object)this.innerModel())).withIntervalInSeconds(seconds);
        return this;
    }

    @Override
    public LoadBalancerProbeImpl withNumberOfProbes(int probes) {
        ((ProbeInner)((Object)this.innerModel())).withNumberOfProbes(probes);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withProbe(this);
    }
}

