/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.WebCategoriesClient;
import com.azure.resourcemanager.network.fluent.models.AzureWebCategoryInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.AzureWebCategoryListResult;
import reactor.core.publisher.Mono;

public final class WebCategoriesClientImpl
implements WebCategoriesClient {
    private final ClientLogger logger = new ClientLogger(WebCategoriesClientImpl.class);
    private final WebCategoriesService service;
    private final NetworkManagementClientImpl client;

    WebCategoriesClientImpl(NetworkManagementClientImpl client) {
        this.service = (WebCategoriesService)RestProxy.create(WebCategoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AzureWebCategoryInner>> getWithResponseAsync(String name, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), name, "2020-11-01", this.client.getSubscriptionId(), expand, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureWebCategoryInner>> getWithResponseAsync(String name, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), name, "2020-11-01", this.client.getSubscriptionId(), expand, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureWebCategoryInner> getAsync(String name, String expand) {
        return this.getWithResponseAsync(name, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AzureWebCategoryInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureWebCategoryInner> getAsync(String name) {
        String expand = null;
        return this.getWithResponseAsync(name, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AzureWebCategoryInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureWebCategoryInner get(String name) {
        String expand = null;
        return (AzureWebCategoryInner)this.getAsync(name, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureWebCategoryInner> getWithResponse(String name, String expand, Context context) {
        return (Response)this.getWithResponseAsync(name, expand, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureWebCategoryInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-11-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureWebCategoryListResult)res.getValue()).value(), ((AzureWebCategoryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureWebCategoryInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2020-11-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureWebCategoryListResult)res.getValue()).value(), ((AzureWebCategoryListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AzureWebCategoryInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureWebCategoryInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureWebCategoryInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureWebCategoryInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureWebCategoryInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureWebCategoryListResult)res.getValue()).value(), ((AzureWebCategoryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureWebCategoryInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureWebCategoryListResult)res.getValue()).value(), ((AzureWebCategoryListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface WebCategoriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/azureWebCategories/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureWebCategoryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/azureWebCategories")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureWebCategoryListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureWebCategoryListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

