/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleNetworkProtocol;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonTypeName(value="NetworkRule")
public final class NetworkRule
extends FirewallPolicyRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkRule.class);
    @JsonProperty(value="ipProtocols")
    private List<FirewallPolicyRuleNetworkProtocol> ipProtocols;
    @JsonProperty(value="sourceAddresses")
    private List<String> sourceAddresses;
    @JsonProperty(value="destinationAddresses")
    private List<String> destinationAddresses;
    @JsonProperty(value="destinationPorts")
    private List<String> destinationPorts;
    @JsonProperty(value="sourceIpGroups")
    private List<String> sourceIpGroups;
    @JsonProperty(value="destinationIpGroups")
    private List<String> destinationIpGroups;
    @JsonProperty(value="destinationFqdns")
    private List<String> destinationFqdns;

    public List<FirewallPolicyRuleNetworkProtocol> ipProtocols() {
        return this.ipProtocols;
    }

    public NetworkRule withIpProtocols(List<FirewallPolicyRuleNetworkProtocol> ipProtocols) {
        this.ipProtocols = ipProtocols;
        return this;
    }

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public NetworkRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public NetworkRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    public NetworkRule withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public NetworkRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    public List<String> destinationIpGroups() {
        return this.destinationIpGroups;
    }

    public NetworkRule withDestinationIpGroups(List<String> destinationIpGroups) {
        this.destinationIpGroups = destinationIpGroups;
        return this;
    }

    public List<String> destinationFqdns() {
        return this.destinationFqdns;
    }

    public NetworkRule withDestinationFqdns(List<String> destinationFqdns) {
        this.destinationFqdns = destinationFqdns;
        return this;
    }

    @Override
    public NetworkRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public NetworkRule withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }
}

