/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PrivateLinkServiceConnection
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateLinkServiceConnection.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.privateLinkServiceId")
    private String privateLinkServiceId;
    @JsonProperty(value="properties.groupIds")
    private List<String> groupIds;
    @JsonProperty(value="properties.requestMessage")
    private String requestMessage;
    @JsonProperty(value="properties.privateLinkServiceConnectionState")
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;

    public String name() {
        return this.name;
    }

    public PrivateLinkServiceConnection withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String privateLinkServiceId() {
        return this.privateLinkServiceId;
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceId(String privateLinkServiceId) {
        this.privateLinkServiceId = privateLinkServiceId;
        return this;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public PrivateLinkServiceConnection withGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public String requestMessage() {
        return this.requestMessage;
    }

    public PrivateLinkServiceConnection withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateLinkServiceConnection withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateLinkServiceConnection withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }
}

