// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.PolicySetDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import com.azure.resourcemanager.resources.models.PolicySetDefinitionListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PolicySetDefinitionsClient. */
public final class PolicySetDefinitionsClientImpl implements PolicySetDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(PolicySetDefinitionsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final PolicySetDefinitionsService service;

    /** The service client containing this operation class. */
    private final PolicyClientImpl client;

    /**
     * Initializes an instance of PolicySetDefinitionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PolicySetDefinitionsClientImpl(PolicyClientImpl client) {
        this.service =
            RestProxy
                .create(PolicySetDefinitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicyClientPolicySetDefinitions to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PolicyClientPolicySe")
    private interface PolicySetDefinitionsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions"
                + "/{policySetDefinitionName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") PolicySetDefinitionInner parameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions"
                + "/{policySetDefinitionName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions"
                + "/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> getBuiltIn(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listBuiltIn(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization"
                + "/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            @BodyParam("application/json") PolicySetDefinitionInner parameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization"
                + "/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> deleteAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization"
                + "/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionInner>> getAtManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization"
                + "/policySetDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listByManagementGroup(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("managementGroupId") String managementGroupId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listBuiltInNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionListResult>> listByManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                context);
    }

    /**
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAsync(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, parameters)
            .flatMap(
                (Response<PolicySetDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdate(
        String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return createOrUpdateAsync(policySetDefinitionName, parameters).block();
    }

    /**
     * This operation creates or updates a policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param parameters The policy set definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateWithResponse(
        String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, parameters, context).block();
    }

    /**
     * This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policySetDefinitionName) {
        return deleteWithResponseAsync(policySetDefinitionName).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String policySetDefinitionName) {
        deleteAsync(policySetDefinitionName).block();
    }

    /**
     * This operation deletes the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policySetDefinitionName, Context context) {
        return deleteWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(
        String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        return getWithResponseAsync(policySetDefinitionName)
            .flatMap(
                (Response<PolicySetDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        return getAsync(policySetDefinitionName).block();
    }

    /**
     * This operation retrieves the policy set definition in the given subscription with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getWithResponse(String policySetDefinitionName, Context context) {
        return getWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getBuiltIn(
                            this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(
        String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), context);
    }

    /**
     * This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        return getBuiltInWithResponseAsync(policySetDefinitionName)
            .flatMap(
                (Response<PolicySetDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        return getBuiltInAsync(policySetDefinitionName).block();
    }

    /**
     * This operation retrieves the built-in policy set definition with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getBuiltInWithResponse(String policySetDefinitionName, Context context) {
        return getBuiltInWithResponseAsync(policySetDefinitionName, context).block();
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listAsync(Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * This operation retrieves a list of all the policy set definitions in the given subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context -> service.listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync() {
        return new PagedFlux<>(
            () -> listBuiltInSinglePageAsync(), nextLink -> listBuiltInNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(Context context) {
        return new PagedFlux<>(
            () -> listBuiltInSinglePageAsync(context), nextLink -> listBuiltInNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn() {
        return new PagedIterable<>(listBuiltInAsync());
    }

    /**
     * This operation retrieves a list of all the built-in policy set definitions.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn(Context context) {
        return new PagedIterable<>(listBuiltInAsync(context));
    }

    /**
     * This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdateAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            managementGroupId,
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String policySetDefinitionName,
        String managementGroupId,
        PolicySetDefinitionInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .createOrUpdateAtManagementGroup(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                managementGroupId,
                parameters,
                context);
    }

    /**
     * This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, parameters)
            .flatMap(
                (Response<PolicySetDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(
        String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return createOrUpdateAtManagementGroupAsync(policySetDefinitionName, managementGroupId, parameters).block();
    }

    /**
     * This operation creates or updates a policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to create.
     * @param managementGroupId The ID of the management group.
     * @param parameters The policy set definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateAtManagementGroupWithResponse(
        String policySetDefinitionName,
        String managementGroupId,
        PolicySetDefinitionInner parameters,
        Context context) {
        return createOrUpdateAtManagementGroupWithResponseAsync(
                policySetDefinitionName, managementGroupId, parameters, context)
            .block();
    }

    /**
     * This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            managementGroupId,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .deleteAtManagementGroup(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                managementGroupId,
                context);
    }

    /**
     * This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        deleteAtManagementGroupAsync(policySetDefinitionName, managementGroupId).block();
    }

    /**
     * This operation deletes the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to delete.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(
        String policySetDefinitionName, String managementGroupId, Context context) {
        return deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getAtManagementGroup(
                            this.client.getEndpoint(),
                            policySetDefinitionName,
                            this.client.getApiVersion(),
                            managementGroupId,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(
        String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .getAtManagementGroup(
                this.client.getEndpoint(),
                policySetDefinitionName,
                this.client.getApiVersion(),
                managementGroupId,
                context);
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAtManagementGroupAsync(
        String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId)
            .flatMap(
                (Response<PolicySetDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        return getAtManagementGroupAsync(policySetDefinitionName, managementGroupId).block();
    }

    /**
     * This operation retrieves the policy set definition in the given management group with the given name.
     *
     * @param policySetDefinitionName The name of the policy set definition to get.
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getAtManagementGroupWithResponse(
        String policySetDefinitionName, String managementGroupId, Context context) {
        return getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByManagementGroup(
                            this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByManagementGroup(this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupId),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId, Context context) {
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupId, context),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId) {
        return new PagedIterable<>(listByManagementGroupAsync(managementGroupId));
    }

    /**
     * This operation retrieves a list of all the a policy set definition in the given management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId, Context context) {
        return new PagedIterable<>(listByManagementGroupAsync(managementGroupId, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listBuiltInNext(nextLink, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listBuiltInNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByManagementGroupNext(nextLink, context))
            .<PagedResponse<PolicySetDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definitions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByManagementGroupNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
