// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.models.LocationInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Location list operation response. */
@Fluent
public final class LocationListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LocationListResult.class);

    /*
     * An array of locations.
     */
    @JsonProperty(value = "value")
    private List<LocationInner> value;

    /**
     * Get the value property: An array of locations.
     *
     * @return the value value.
     */
    public List<LocationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of locations.
     *
     * @param value the value value to set.
     * @return the LocationListResult object itself.
     */
    public LocationListResult withValue(List<LocationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
