/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.FeaturesClient;
import com.azure.resourcemanager.resources.fluent.models.FeatureResultInner;
import com.azure.resourcemanager.resources.implementation.FeatureClientImpl;
import com.azure.resourcemanager.resources.models.FeatureOperationsListResult;
import reactor.core.publisher.Mono;

public final class FeaturesClientImpl
implements FeaturesClient {
    private final ClientLogger logger = new ClientLogger(FeaturesClientImpl.class);
    private final FeaturesService service;
    private final FeatureClientImpl client;

    FeaturesClientImpl(FeatureClientImpl client) {
        this.service = (FeaturesService)RestProxy.create(FeaturesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<FeatureResultInner>> listAllSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAll(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FeatureResultInner>> listAllSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAll(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<FeatureResultInner> listAllAsync() {
        return new PagedFlux(() -> this.listAllSinglePageAsync(), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<FeatureResultInner> listAllAsync(Context context) {
        return new PagedFlux(() -> this.listAllSinglePageAsync(context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<FeatureResultInner> listAll() {
        return new PagedIterable(this.listAllAsync());
    }

    @Override
    public PagedIterable<FeatureResultInner> listAll(Context context) {
        return new PagedIterable(this.listAllAsync(context));
    }

    private Mono<PagedResponse<FeatureResultInner>> listSinglePageAsync(String resourceProviderNamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FeatureResultInner>> listSinglePageAsync(String resourceProviderNamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceProviderNamespace, this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<FeatureResultInner> listAsync(String resourceProviderNamespace) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceProviderNamespace), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<FeatureResultInner> listAsync(String resourceProviderNamespace, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceProviderNamespace, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<FeatureResultInner> list(String resourceProviderNamespace) {
        return new PagedIterable(this.listAsync(resourceProviderNamespace));
    }

    @Override
    public PagedIterable<FeatureResultInner> list(String resourceProviderNamespace, Context context) {
        return new PagedIterable(this.listAsync(resourceProviderNamespace, context));
    }

    @Override
    public Mono<Response<FeatureResultInner>> getWithResponseAsync(String resourceProviderNamespace, String featureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FeatureResultInner>> getWithResponseAsync(String resourceProviderNamespace, String featureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<FeatureResultInner> getAsync(String resourceProviderNamespace, String featureName) {
        return this.getWithResponseAsync(resourceProviderNamespace, featureName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((FeatureResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public FeatureResultInner get(String resourceProviderNamespace, String featureName) {
        return (FeatureResultInner)this.getAsync(resourceProviderNamespace, featureName).block();
    }

    @Override
    public Response<FeatureResultInner> getWithResponse(String resourceProviderNamespace, String featureName, Context context) {
        return (Response)this.getWithResponseAsync(resourceProviderNamespace, featureName, context).block();
    }

    @Override
    public Mono<Response<FeatureResultInner>> registerWithResponseAsync(String resourceProviderNamespace, String featureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.register(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FeatureResultInner>> registerWithResponseAsync(String resourceProviderNamespace, String featureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.register(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<FeatureResultInner> registerAsync(String resourceProviderNamespace, String featureName) {
        return this.registerWithResponseAsync(resourceProviderNamespace, featureName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((FeatureResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public FeatureResultInner register(String resourceProviderNamespace, String featureName) {
        return (FeatureResultInner)this.registerAsync(resourceProviderNamespace, featureName).block();
    }

    @Override
    public Response<FeatureResultInner> registerWithResponse(String resourceProviderNamespace, String featureName, Context context) {
        return (Response)this.registerWithResponseAsync(resourceProviderNamespace, featureName, context).block();
    }

    @Override
    public Mono<Response<FeatureResultInner>> unregisterWithResponseAsync(String resourceProviderNamespace, String featureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.unregister(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FeatureResultInner>> unregisterWithResponseAsync(String resourceProviderNamespace, String featureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.unregister(this.client.getEndpoint(), resourceProviderNamespace, featureName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<FeatureResultInner> unregisterAsync(String resourceProviderNamespace, String featureName) {
        return this.unregisterWithResponseAsync(resourceProviderNamespace, featureName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((FeatureResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public FeatureResultInner unregister(String resourceProviderNamespace, String featureName) {
        return (FeatureResultInner)this.unregisterAsync(resourceProviderNamespace, featureName).block();
    }

    @Override
    public Response<FeatureResultInner> unregisterWithResponse(String resourceProviderNamespace, String featureName, Context context) {
        return (Response)this.unregisterWithResponseAsync(resourceProviderNamespace, featureName, context).block();
    }

    private Mono<PagedResponse<FeatureResultInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FeatureResultInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<FeatureResultInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FeatureResultInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FeatureOperationsListResult)res.getValue()).value(), ((FeatureOperationsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FeatureClientFeature")
    private static interface FeaturesService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Features/features")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureOperationsListResult>> listAll(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureOperationsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @PathParam(value="featureName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}/register")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureResultInner>> register(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @PathParam(value="featureName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Features/providers/{resourceProviderNamespace}/features/{featureName}/unregister")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureResultInner>> unregister(@HostParam(value="$host") String var1, @PathParam(value="resourceProviderNamespace") String var2, @PathParam(value="featureName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureOperationsListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureOperationsListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

