/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.AuthorizationOperationsClient;
import com.azure.resourcemanager.resources.fluent.ManagementLockClient;
import com.azure.resourcemanager.resources.fluent.ManagementLocksClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.resources.implementation.AuthorizationOperationsClientImpl;
import com.azure.resourcemanager.resources.implementation.ManagementLocksClientImpl;
import java.time.Duration;

public final class ManagementLockClientImpl
extends AzureServiceClient
implements ManagementLockClient {
    private final ClientLogger logger = new ClientLogger(ManagementLockClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AuthorizationOperationsClient authorizationOperations;
    private final ManagementLocksClient managementLocks;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AuthorizationOperationsClient getAuthorizationOperations() {
        return this.authorizationOperations;
    }

    @Override
    public ManagementLocksClient getManagementLocks() {
        return this.managementLocks;
    }

    ManagementLockClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2016-09-01";
        this.authorizationOperations = new AuthorizationOperationsClientImpl(this);
        this.managementLocks = new ManagementLocksClientImpl(this);
    }
}

