/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.PolicySetDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import com.azure.resourcemanager.resources.implementation.PolicyClientImpl;
import com.azure.resourcemanager.resources.models.PolicySetDefinitionListResult;
import reactor.core.publisher.Mono;

public final class PolicySetDefinitionsClientImpl
implements PolicySetDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(PolicySetDefinitionsClientImpl.class);
    private final PolicySetDefinitionsService service;
    private final PolicyClientImpl client;

    PolicySetDefinitionsClientImpl(PolicyClientImpl client) {
        this.service = (PolicySetDefinitionsService)RestProxy.create(PolicySetDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateWithResponseAsync(policySetDefinitionName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicySetDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicySetDefinitionInner createOrUpdate(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return (PolicySetDefinitionInner)((Object)this.createOrUpdateAsync(policySetDefinitionName, parameters).block());
    }

    @Override
    public Response<PolicySetDefinitionInner> createOrUpdateWithResponse(String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(policySetDefinitionName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String policySetDefinitionName) {
        return this.deleteWithResponseAsync(policySetDefinitionName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String policySetDefinitionName) {
        this.deleteAsync(policySetDefinitionName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String policySetDefinitionName, Context context) {
        return (Response)this.deleteWithResponseAsync(policySetDefinitionName, context).block();
    }

    @Override
    public Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        return this.getWithResponseAsync(policySetDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicySetDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        return (PolicySetDefinitionInner)((Object)this.getAsync(policySetDefinitionName).block());
    }

    @Override
    public Response<PolicySetDefinitionInner> getWithResponse(String policySetDefinitionName, Context context) {
        return (Response)this.getWithResponseAsync(policySetDefinitionName, context).block();
    }

    @Override
    public Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), context);
    }

    @Override
    public Mono<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        return this.getBuiltInWithResponseAsync(policySetDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicySetDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        return (PolicySetDefinitionInner)((Object)this.getBuiltInAsync(policySetDefinitionName).block());
    }

    @Override
    public Response<PolicySetDefinitionInner> getBuiltInWithResponse(String policySetDefinitionName, Context context) {
        return (Response)this.getBuiltInWithResponseAsync(policySetDefinitionName, context).block();
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicySetDefinitionInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicySetDefinitionInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBuiltIn(this.client.getEndpoint(), this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync() {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(Context context) {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(context), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn() {
        return new PagedIterable(this.listBuiltInAsync());
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn(Context context) {
        return new PagedIterable(this.listBuiltInAsync(context));
    }

    @Override
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, parameters, context);
    }

    @Override
    public Mono<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicySetDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters) {
        return (PolicySetDefinitionInner)((Object)this.createOrUpdateAtManagementGroupAsync(policySetDefinitionName, managementGroupId, parameters).block());
    }

    @Override
    public Response<PolicySetDefinitionInner> createOrUpdateAtManagementGroupWithResponse(String policySetDefinitionName, String managementGroupId, PolicySetDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, context);
    }

    @Override
    public Mono<Void> deleteAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return this.deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        this.deleteAtManagementGroupAsync(policySetDefinitionName, managementGroupId).block();
    }

    @Override
    public Response<Void> deleteAtManagementGroupWithResponse(String policySetDefinitionName, String managementGroupId, Context context) {
        return (Response)this.deleteAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    @Override
    public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(String policySetDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), policySetDefinitionName, this.client.getApiVersion(), managementGroupId, context);
    }

    @Override
    public Mono<PolicySetDefinitionInner> getAtManagementGroupAsync(String policySetDefinitionName, String managementGroupId) {
        return this.getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicySetDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PolicySetDefinitionInner getAtManagementGroup(String policySetDefinitionName, String managementGroupId) {
        return (PolicySetDefinitionInner)((Object)this.getAtManagementGroupAsync(policySetDefinitionName, managementGroupId).block());
    }

    @Override
    public Response<PolicySetDefinitionInner> getAtManagementGroupWithResponse(String policySetDefinitionName, String managementGroupId, Context context) {
        return (Response)this.getAtManagementGroupWithResponseAsync(policySetDefinitionName, managementGroupId, context).block();
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByManagementGroup(this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroup(this.client.getEndpoint(), this.client.getApiVersion(), managementGroupId, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId, Context context) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, context), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId) {
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId));
    }

    @Override
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId, Context context) {
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId, context));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBuiltInNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBuiltInNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByManagementGroupNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroupNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyClientPolicySe")
    private static interface PolicySetDefinitionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") PolicySetDefinitionInner var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> getBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listBuiltIn(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, @BodyParam(value="application/json") PolicySetDefinitionInner var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listByManagementGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="managementGroupId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listBuiltInNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listByManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

