/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.ResourceNamesClient;
import com.azure.resourcemanager.resources.fluent.SubscriptionClient;
import com.azure.resourcemanager.resources.fluent.SubscriptionsClient;
import com.azure.resourcemanager.resources.fluent.TenantsClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.resources.implementation.ResourceNamesClientImpl;
import com.azure.resourcemanager.resources.implementation.SubscriptionsClientImpl;
import com.azure.resourcemanager.resources.implementation.TenantsClientImpl;
import java.time.Duration;

public final class SubscriptionClientImpl
extends AzureServiceClient
implements SubscriptionClient {
    private final ClientLogger logger = new ClientLogger(SubscriptionClientImpl.class);
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final SubscriptionsClient subscriptions;
    private final TenantsClient tenants;
    private final ResourceNamesClient resourceNames;

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public SubscriptionsClient getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public TenantsClient getTenants() {
        return this.tenants;
    }

    @Override
    public ResourceNamesClient getResourceNames() {
        return this.resourceNames;
    }

    SubscriptionClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.apiVersion = "2020-01-01";
        this.subscriptions = new SubscriptionsClientImpl(this);
        this.tenants = new TenantsClientImpl(this);
        this.resourceNames = new ResourceNamesClientImpl(this);
    }
}

