/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ChangeType;
import com.azure.resourcemanager.resources.models.WhatIfPropertyChange;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WhatIfChange {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WhatIfChange.class);
    @JsonProperty(value="resourceId", required=true)
    private String resourceId;
    @JsonProperty(value="changeType", required=true)
    private ChangeType changeType;
    @JsonProperty(value="before")
    private Object before;
    @JsonProperty(value="after")
    private Object after;
    @JsonProperty(value="delta")
    private List<WhatIfPropertyChange> delta;

    public String resourceId() {
        return this.resourceId;
    }

    public WhatIfChange withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ChangeType changeType() {
        return this.changeType;
    }

    public WhatIfChange withChangeType(ChangeType changeType) {
        this.changeType = changeType;
        return this;
    }

    public Object before() {
        return this.before;
    }

    public WhatIfChange withBefore(Object before) {
        this.before = before;
        return this;
    }

    public Object after() {
        return this.after;
    }

    public WhatIfChange withAfter(Object after) {
        this.after = after;
        return this;
    }

    public List<WhatIfPropertyChange> delta() {
        return this.delta;
    }

    public WhatIfChange withDelta(List<WhatIfPropertyChange> delta) {
        this.delta = delta;
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model WhatIfChange"));
        }
        if (this.changeType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property changeType in model WhatIfChange"));
        }
        if (this.delta() != null) {
            this.delta().forEach(e -> e.validate());
        }
    }
}

