// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.RecoverableDatabaseInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response to a list recoverable databases request. */
@Fluent
public final class RecoverableDatabaseListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RecoverableDatabaseListResult.class);

    /*
     * A list of recoverable databases
     */
    @JsonProperty(value = "value", required = true)
    private List<RecoverableDatabaseInner> value;

    /**
     * Get the value property: A list of recoverable databases.
     *
     * @return the value value.
     */
    public List<RecoverableDatabaseInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of recoverable databases.
     *
     * @param value the value value to set.
     * @return the RecoverableDatabaseListResult object itself.
     */
    public RecoverableDatabaseListResult withValue(List<RecoverableDatabaseInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model RecoverableDatabaseListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }
}
