/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class ListContainerItemInner
extends AzureEntityResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ListContainerItemInner.class);
    @JsonProperty(value="properties.version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="properties.deleted", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean deleted;
    @JsonProperty(value="properties.deletedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime deletedTime;
    @JsonProperty(value="properties.remainingRetentionDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer remainingRetentionDays;
    @JsonProperty(value="properties.defaultEncryptionScope")
    private String defaultEncryptionScope;
    @JsonProperty(value="properties.denyEncryptionScopeOverride")
    private Boolean denyEncryptionScopeOverride;
    @JsonProperty(value="properties.publicAccess")
    private PublicAccess publicAccess;
    @JsonProperty(value="properties.lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="properties.leaseStatus", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseStatus leaseStatus;
    @JsonProperty(value="properties.leaseState", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseState leaseState;
    @JsonProperty(value="properties.leaseDuration", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseDuration leaseDuration;
    @JsonProperty(value="properties.metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="properties.immutabilityPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private ImmutabilityPolicyProperties immutabilityPolicy;
    @JsonProperty(value="properties.legalHold", access=JsonProperty.Access.WRITE_ONLY)
    private LegalHoldProperties legalHold;
    @JsonProperty(value="properties.hasLegalHold", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasLegalHold;
    @JsonProperty(value="properties.hasImmutabilityPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasImmutabilityPolicy;

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public String defaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public ListContainerItemInner withDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.denyEncryptionScopeOverride;
    }

    public ListContainerItemInner withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        this.denyEncryptionScopeOverride = denyEncryptionScopeOverride;
        return this;
    }

    public PublicAccess publicAccess() {
        return this.publicAccess;
    }

    public ListContainerItemInner withPublicAccess(PublicAccess publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ListContainerItemInner withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public LegalHoldProperties legalHold() {
        return this.legalHold;
    }

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public Boolean hasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.immutabilityPolicy() != null) {
            this.immutabilityPolicy().validate();
        }
        if (this.legalHold() != null) {
            this.legalHold().validate();
        }
    }
}

