/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.BlobInventoryPoliciesClient;
import com.azure.resourcemanager.storage.fluent.models.BlobInventoryPolicyInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicyName;
import com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import com.azure.resourcemanager.storage.models.ListBlobInventoryPolicy;
import reactor.core.publisher.Mono;

public final class BlobInventoryPoliciesClientImpl
implements BlobInventoryPoliciesClient {
    private final ClientLogger logger = new ClientLogger(BlobInventoryPoliciesClientImpl.class);
    private final BlobInventoryPoliciesService service;
    private final StorageManagementClientImpl client;

    BlobInventoryPoliciesClientImpl(StorageManagementClientImpl client) {
        this.service = (BlobInventoryPoliciesService)RestProxy.create(BlobInventoryPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobInventoryPolicyInner>> getWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BlobInventoryPolicyInner>> getWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobInventoryPolicyInner> getAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobInventoryPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobInventoryPolicyInner get(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        return (BlobInventoryPolicyInner)((Object)this.getAsync(resourceGroupName, accountName, blobInventoryPolicyName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobInventoryPolicyInner> getWithResponse(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobInventoryPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, BlobInventoryPolicySchema policy) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        if (policy != null) {
            policy.validate();
        }
        String accept = "application/json";
        BlobInventoryPolicyInner properties = new BlobInventoryPolicyInner();
        properties.withPolicy(policy);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BlobInventoryPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, BlobInventoryPolicySchema policy, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        if (policy != null) {
            policy.validate();
        }
        String accept = "application/json";
        BlobInventoryPolicyInner properties = new BlobInventoryPolicyInner();
        properties.withPolicy(policy);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobInventoryPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, BlobInventoryPolicySchema policy) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName, policy).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobInventoryPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobInventoryPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        BlobInventoryPolicySchema policy = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName, policy).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobInventoryPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobInventoryPolicyInner createOrUpdate(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        BlobInventoryPolicySchema policy = null;
        return (BlobInventoryPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, accountName, blobInventoryPolicyName, policy).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobInventoryPolicyInner> createOrUpdateWithResponse(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, BlobInventoryPolicySchema policy, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName, policy, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobInventoryPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobInventoryPolicyName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobInventoryPolicyName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        return this.deleteWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName) {
        this.deleteAsync(resourceGroupName, accountName, blobInventoryPolicyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, BlobInventoryPolicyName blobInventoryPolicyName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, accountName, blobInventoryPolicyName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BlobInventoryPolicyInner>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListBlobInventoryPolicy)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BlobInventoryPolicyInner>> listSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListBlobInventoryPolicy)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobInventoryPolicyInner> listAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BlobInventoryPolicyInner> listAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobInventoryPolicyInner> list(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobInventoryPolicyInner> list(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface BlobInventoryPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies/{blobInventoryPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BlobInventoryPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="blobInventoryPolicyName") BlobInventoryPolicyName var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies/{blobInventoryPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BlobInventoryPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="blobInventoryPolicyName") BlobInventoryPolicyName var6, @BodyParam(value="application/json") BlobInventoryPolicyInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies/{blobInventoryPolicyName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="blobInventoryPolicyName") BlobInventoryPolicyName var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListBlobInventoryPolicy>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

