/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.MybatisMapperRegistry;
import com.baomidou.mybatisplus.core.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.executor.MybatisBatchExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisCachingExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisReuseExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisSimpleExecutor;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;

public class MybatisConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(MybatisConfiguration.class);
    protected final MybatisMapperRegistry mybatisMapperRegistry = new MybatisMapperRegistry(this);
    protected final Map<String, Cache> caches = new StrictMap<Cache>("Caches collection");
    protected final Map<String, ResultMap> resultMaps = new StrictMap<ResultMap>("Result Maps collection");
    protected final Map<String, ParameterMap> parameterMaps = new StrictMap<ParameterMap>("Parameter Maps collection");
    protected final Map<String, KeyGenerator> keyGenerators = new StrictMap<KeyGenerator>("Key Generators collection");
    protected final Map<String, XNode> sqlFragments = new StrictMap<XNode>("XML fragments parsed from previous mappers");
    protected final Map<String, MappedStatement> mappedStatements = new StrictMap<MappedStatement>("Mapped Statements collection").conflictMessageProducer((savedValue, targetValue) -> ". please check " + savedValue.getResource() + " and " + targetValue.getResource());
    private boolean useGeneratedShortKey = true;
    @Deprecated
    private boolean useDeprecatedExecutor = true;

    public MybatisConfiguration(Environment environment) {
        this();
        this.environment = environment;
    }

    @Deprecated
    public GlobalConfig getGlobalConfig() {
        return GlobalConfigUtils.getGlobalConfig(this);
    }

    @Deprecated
    public void setGlobalConfig(GlobalConfig globalConfig) {
        GlobalConfigUtils.setGlobalConfig(this, globalConfig);
    }

    public MybatisConfiguration() {
        this.mapUnderscoreToCamelCase = true;
        this.languageRegistry.setDefaultDriverClass(MybatisXMLLanguageDriver.class);
    }

    public void addMappedStatement(MappedStatement ms) {
        logger.debug("addMappedStatement: " + ms.getId());
        if (this.mappedStatements.containsKey(ms.getId())) {
            logger.error("mapper[" + ms.getId() + "] is ignored, because it exists, maybe from xml file");
            return;
        }
        this.mappedStatements.put(ms.getId(), ms);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }

    public void setDefaultScriptingLanguage(Class<? extends LanguageDriver> driver) {
        if (driver == null) {
            driver = MybatisXMLLanguageDriver.class;
        }
        this.getLanguageRegistry().setDefaultDriverClass(driver);
    }

    public void addKeyGenerator(String id, KeyGenerator keyGenerator) {
        this.keyGenerators.put(id, keyGenerator);
    }

    public Collection<String> getKeyGeneratorNames() {
        return this.keyGenerators.keySet();
    }

    public Collection<KeyGenerator> getKeyGenerators() {
        return this.keyGenerators.values();
    }

    public KeyGenerator getKeyGenerator(String id) {
        return this.keyGenerators.get(id);
    }

    public boolean hasKeyGenerator(String id) {
        return this.keyGenerators.containsKey(id);
    }

    public void addCache(Cache cache) {
        this.caches.put(cache.getId(), cache);
    }

    public Collection<String> getCacheNames() {
        return this.caches.keySet();
    }

    public Collection<Cache> getCaches() {
        return this.caches.values();
    }

    public Cache getCache(String id) {
        return this.caches.get(id);
    }

    public boolean hasCache(String id) {
        return this.caches.containsKey(id);
    }

    public void addResultMap(ResultMap rm) {
        this.resultMaps.put(rm.getId(), rm);
        this.checkLocallyForDiscriminatedNestedResultMaps(rm);
        this.checkGloballyForDiscriminatedNestedResultMaps(rm);
    }

    public Collection<String> getResultMapNames() {
        return this.resultMaps.keySet();
    }

    public Collection<ResultMap> getResultMaps() {
        return this.resultMaps.values();
    }

    public ResultMap getResultMap(String id) {
        return this.resultMaps.get(id);
    }

    public boolean hasResultMap(String id) {
        return this.resultMaps.containsKey(id);
    }

    public void addParameterMap(ParameterMap pm) {
        this.parameterMaps.put(pm.getId(), pm);
    }

    public Collection<String> getParameterMapNames() {
        return this.parameterMaps.keySet();
    }

    public Collection<ParameterMap> getParameterMaps() {
        return this.parameterMaps.values();
    }

    public ParameterMap getParameterMap(String id) {
        return this.parameterMaps.get(id);
    }

    public boolean hasParameterMap(String id) {
        return this.parameterMaps.containsKey(id);
    }

    public Map<String, XNode> getSqlFragments() {
        return this.sqlFragments;
    }

    public Collection<String> getMappedStatementNames() {
        this.buildAllStatements();
        return this.mappedStatements.keySet();
    }

    public Collection<MappedStatement> getMappedStatements() {
        this.buildAllStatements();
        return this.mappedStatements.values();
    }

    public MappedStatement getMappedStatement(String id) {
        return this.getMappedStatement(id, true);
    }

    public MappedStatement getMappedStatement(String id, boolean validateIncompleteStatements) {
        if (validateIncompleteStatements) {
            this.buildAllStatements();
        }
        return this.mappedStatements.get(id);
    }

    public boolean hasStatement(String statementName, boolean validateIncompleteStatements) {
        if (validateIncompleteStatements) {
            this.buildAllStatements();
        }
        return this.mappedStatements.containsKey(statementName);
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        if (this.useDeprecatedExecutor) {
            executorType = executorType == null ? this.defaultExecutorType : executorType;
            ExecutorType executorType2 = executorType = executorType == null ? ExecutorType.SIMPLE : executorType;
            Object executor = ExecutorType.BATCH == executorType ? new MybatisBatchExecutor(this, transaction) : (ExecutorType.REUSE == executorType ? new MybatisReuseExecutor(this, transaction) : new MybatisSimpleExecutor(this, transaction));
            if (this.cacheEnabled) {
                executor = new MybatisCachingExecutor((Executor)executor);
            }
            executor = (Executor)this.interceptorChain.pluginAll(executor);
            return executor;
        }
        return super.newExecutor(transaction, executorType);
    }

    protected void checkGloballyForDiscriminatedNestedResultMaps(ResultMap rm) {
        if (rm.hasNestedResultMaps()) {
            for (Map.Entry<String, ResultMap> entry : this.resultMaps.entrySet()) {
                Collection discriminatedResultMapNames;
                ResultMap entryResultMap;
                ResultMap value = entry.getValue();
                if (!(value instanceof ResultMap) || (entryResultMap = value).hasNestedResultMaps() || entryResultMap.getDiscriminator() == null || !(discriminatedResultMapNames = entryResultMap.getDiscriminator().getDiscriminatorMap().values()).contains(rm.getId())) continue;
                entryResultMap.forceNestedResultMaps();
            }
        }
    }

    protected void checkLocallyForDiscriminatedNestedResultMaps(ResultMap rm) {
        if (!rm.hasNestedResultMaps() && rm.getDiscriminator() != null) {
            for (Map.Entry entry : rm.getDiscriminator().getDiscriminatorMap().entrySet()) {
                ResultMap discriminatedResultMap;
                String discriminatedResultMapName = (String)entry.getValue();
                if (!this.hasResultMap(discriminatedResultMapName) || !(discriminatedResultMap = this.resultMaps.get(discriminatedResultMapName)).hasNestedResultMaps()) continue;
                rm.forceNestedResultMaps();
                break;
            }
        }
    }

    public void setUseGeneratedShortKey(boolean useGeneratedShortKey) {
        this.useGeneratedShortKey = useGeneratedShortKey;
    }

    public boolean isUseGeneratedShortKey() {
        return this.useGeneratedShortKey;
    }

    @Deprecated
    public void setUseDeprecatedExecutor(boolean useDeprecatedExecutor) {
        this.useDeprecatedExecutor = useDeprecatedExecutor;
    }

    @Deprecated
    public boolean isUseDeprecatedExecutor() {
        return this.useDeprecatedExecutor;
    }

    protected class StrictMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -4950446264854982944L;
        private final String name;
        private BiFunction<V, V, String> conflictMessageProducer;

        public StrictMap(String name) {
            this.name = name;
        }

        public StrictMap<V> conflictMessageProducer(BiFunction<V, V, String> conflictMessageProducer) {
            this.conflictMessageProducer = conflictMessageProducer;
            return this;
        }

        @Override
        public V put(String key, V value) {
            if (this.containsKey(key)) {
                throw new IllegalArgumentException(this.name + " already contains value for " + key + (this.conflictMessageProducer == null ? "" : this.conflictMessageProducer.apply(super.get(key), value)));
            }
            if (MybatisConfiguration.this.useGeneratedShortKey && key.contains(".")) {
                String shortKey = this.getShortName(key);
                if (super.get(shortKey) == null) {
                    super.put(shortKey, value);
                } else {
                    super.put(shortKey, new Ambiguity(shortKey));
                }
            }
            return super.put(key, value);
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            if (value == null) {
                throw new IllegalArgumentException(this.name + " does not contain value for " + key);
            }
            if (MybatisConfiguration.this.useGeneratedShortKey && value instanceof Ambiguity) {
                throw new IllegalArgumentException(((Ambiguity)value).getSubject() + " is ambiguous in " + this.name + " (try using the full name including the namespace, or rename one of the entries)");
            }
            return value;
        }

        private String getShortName(String key) {
            String[] keyParts = key.split("\\.");
            return keyParts[keyParts.length - 1];
        }

        protected class Ambiguity {
            private final String subject;

            public Ambiguity(String subject) {
                this.subject = subject;
            }

            public String getSubject() {
                return this.subject;
            }
        }
    }
}

