/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.UtilsBridge;
import java.util.ArrayList;
import java.util.List;

public final class UiMessageUtils
implements Handler.Callback {
    private static final String TAG = "UiMessageUtils";
    private static final boolean DEBUG = UtilsBridge.isAppDebug();
    private final Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    private final UiMessage mMessage = new UiMessage(null);
    private final SparseArray<List<UiMessageCallback>> mListenersSpecific = new SparseArray();
    private final List<UiMessageCallback> mListenersUniversal = new ArrayList<UiMessageCallback>();
    private final List<UiMessageCallback> mDefensiveCopyList = new ArrayList<UiMessageCallback>();

    public static UiMessageUtils getInstance() {
        return LazyHolder.INSTANCE;
    }

    private UiMessageUtils() {
    }

    public final void send(int id2) {
        this.mHandler.sendEmptyMessage(id2);
    }

    public final void send(int id2, @NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument 'obj' of type Object (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(id2, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(int id2, @NonNull UiMessageCallback listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type UiMessageCallback (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        SparseArray<List<UiMessageCallback>> sparseArray = this.mListenersSpecific;
        synchronized (sparseArray) {
            ArrayList<UiMessageCallback> idListeners = (ArrayList<UiMessageCallback>)this.mListenersSpecific.get(id2);
            if (idListeners == null) {
                idListeners = new ArrayList<UiMessageCallback>();
                this.mListenersSpecific.put(id2, idListeners);
            }
            if (!idListeners.contains(listener)) {
                idListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull UiMessageCallback listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type UiMessageCallback (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<UiMessageCallback> list = this.mListenersUniversal;
        synchronized (list) {
            if (!this.mListenersUniversal.contains(listener)) {
                this.mListenersUniversal.add(listener);
            } else if (DEBUG) {
                Log.w((String)TAG, (String)("Listener is already added. " + listener.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull UiMessageCallback listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type UiMessageCallback (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<UiMessageCallback> list = this.mListenersUniversal;
        synchronized (list) {
            if (DEBUG && !this.mListenersUniversal.contains(listener)) {
                Log.w((String)TAG, (String)("Trying to remove a listener that is not registered. " + listener.toString()));
            }
            this.mListenersUniversal.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(int id2) {
        List callbacks;
        if (DEBUG && ((callbacks = (List)this.mListenersSpecific.get(id2)) == null || callbacks.size() == 0)) {
            Log.w((String)TAG, (String)("Trying to remove specific listeners that are not registered. ID " + id2));
        }
        SparseArray<List<UiMessageCallback>> sparseArray = this.mListenersSpecific;
        synchronized (sparseArray) {
            this.mListenersSpecific.delete(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(int id2, @NonNull UiMessageCallback listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type UiMessageCallback (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        SparseArray<List<UiMessageCallback>> sparseArray = this.mListenersSpecific;
        synchronized (sparseArray) {
            List callbacks = (List)this.mListenersSpecific.get(id2);
            if (callbacks != null && !callbacks.isEmpty()) {
                if (DEBUG && !callbacks.contains(listener)) {
                    Log.w((String)TAG, (String)("Trying to remove specific listener that is not registered. ID " + id2 + ", " + listener));
                    return;
                }
                callbacks.remove(listener);
            } else if (DEBUG) {
                Log.w((String)TAG, (String)("Trying to remove specific listener that is not registered. ID " + id2 + ", " + listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        this.mMessage.setMessage(msg);
        if (DEBUG) {
            this.logMessageHandling(this.mMessage);
        }
        Object object = this.mListenersSpecific;
        synchronized (object) {
            List idListeners = (List)this.mListenersSpecific.get(msg.what);
            if (idListeners != null) {
                if (idListeners.size() == 0) {
                    this.mListenersSpecific.remove(msg.what);
                } else {
                    this.mDefensiveCopyList.addAll(idListeners);
                    for (UiMessageCallback callback : this.mDefensiveCopyList) {
                        callback.handleMessage(this.mMessage);
                    }
                    this.mDefensiveCopyList.clear();
                }
            }
        }
        object = this.mListenersUniversal;
        synchronized (object) {
            if (this.mListenersUniversal.size() > 0) {
                this.mDefensiveCopyList.addAll(this.mListenersUniversal);
                for (UiMessageCallback callback : this.mDefensiveCopyList) {
                    callback.handleMessage(this.mMessage);
                }
                this.mDefensiveCopyList.clear();
            }
        }
        this.mMessage.setMessage(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageHandling(@NonNull UiMessage msg) {
        if (msg == null) {
            throw new NullPointerException("Argument 'msg' of type UiMessage (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List idListeners = (List)this.mListenersSpecific.get(msg.getId());
        if ((idListeners == null || idListeners.size() == 0) && this.mListenersUniversal.size() == 0) {
            Log.w((String)TAG, (String)("Delivering FAILED for message ID " + msg.getId() + ". No listeners. " + msg.toString()));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Delivering message ID ");
            stringBuilder.append(msg.getId());
            stringBuilder.append(", Specific listeners: ");
            if (idListeners == null || idListeners.size() == 0) {
                stringBuilder.append(0);
            } else {
                stringBuilder.append(idListeners.size());
                stringBuilder.append(" [");
                for (int i = 0; i < idListeners.size(); ++i) {
                    stringBuilder.append(((UiMessageCallback)idListeners.get(i)).getClass().getSimpleName());
                    if (i >= idListeners.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
            }
            stringBuilder.append(", Universal listeners: ");
            List<UiMessageCallback> list = this.mListenersUniversal;
            synchronized (list) {
                if (this.mListenersUniversal.size() == 0) {
                    stringBuilder.append(0);
                } else {
                    stringBuilder.append(this.mListenersUniversal.size());
                    stringBuilder.append(" [");
                    for (int i = 0; i < this.mListenersUniversal.size(); ++i) {
                        stringBuilder.append(this.mListenersUniversal.get(i).getClass().getSimpleName());
                        if (i >= this.mListenersUniversal.size() - 1) continue;
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("], Message: ");
                }
            }
            stringBuilder.append(msg.toString());
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
    }

    private static final class LazyHolder {
        private static final UiMessageUtils INSTANCE = new UiMessageUtils();

        private LazyHolder() {
        }
    }

    public static interface UiMessageCallback {
        public void handleMessage(@NonNull UiMessage var1);
    }

    public static final class UiMessage {
        private Message mMessage;

        private UiMessage(Message message) {
            this.mMessage = message;
        }

        private void setMessage(Message message) {
            this.mMessage = message;
        }

        public int getId() {
            return this.mMessage.what;
        }

        public Object getObject() {
            return this.mMessage.obj;
        }

        public String toString() {
            return "{ id=" + this.getId() + ", obj=" + this.getObject() + " }";
        }
    }
}

