/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.lang.reflect.Field;

public final class KeyboardUtils {
    private static final int TAG_ON_GLOBAL_LAYOUT_LISTENER = -8;
    private static long millis;
    private static int sDecorViewDelta;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showSoftInput() {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(2, 1);
    }

    public static void showSoftInput(@NonNull Activity activity) {
        if (!KeyboardUtils.isSoftInputVisible(activity)) {
            KeyboardUtils.toggleSoftInput();
        }
    }

    public static void showSoftInput(@NonNull View view) {
        KeyboardUtils.showSoftInput(view, 0);
    }

    public static void showSoftInput(@NonNull View view, int flags) {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, flags, new ResultReceiver(new Handler()){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 1 || resultCode == 3) {
                    KeyboardUtils.toggleSoftInput();
                }
            }
        });
        imm.toggleSoftInput(2, 1);
    }

    public static void hideSoftInput(@NonNull Activity activity) {
        KeyboardUtils.hideSoftInput(activity.getWindow());
    }

    public static void hideSoftInput(@NonNull Window window) {
        View view = window.getCurrentFocus();
        if (view == null) {
            View decorView = window.getDecorView();
            View focusView = decorView.findViewWithTag((Object)"keyboardTagView");
            if (focusView == null) {
                view = new EditText(window.getContext());
                view.setTag((Object)"keyboardTagView");
                ((ViewGroup)decorView).addView(view, 0, 0);
            } else {
                view = focusView;
            }
            view.requestFocus();
        }
        KeyboardUtils.hideSoftInput(view);
    }

    public static void hideSoftInput(@NonNull View view) {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInputByToggle(Activity activity) {
        long nowMillis = SystemClock.elapsedRealtime();
        long delta = nowMillis - millis;
        if (Math.abs(delta) > 500L && KeyboardUtils.isSoftInputVisible(activity)) {
            KeyboardUtils.toggleSoftInput();
        }
        millis = nowMillis;
    }

    public static void toggleSoftInput() {
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(0, 0);
    }

    public static boolean isSoftInputVisible(@NonNull Activity activity) {
        return KeyboardUtils.getDecorViewInvisibleHeight(activity.getWindow()) > 0;
    }

    private static int getDecorViewInvisibleHeight(@NonNull Window window) {
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        Log.d((String)"KeyboardUtils", (String)("getDecorViewInvisibleHeight: " + (decorView.getBottom() - outRect.bottom)));
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= UtilsBridge.getNavBarHeight() + UtilsBridge.getStatusBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void registerSoftInputChangedListener(@NonNull Activity activity, @NonNull OnSoftInputChangedListener listener) {
        KeyboardUtils.registerSoftInputChangedListener(activity.getWindow(), listener);
    }

    public static void registerSoftInputChangedListener(final @NonNull Window window, final @NonNull OnSoftInputChangedListener listener) {
        int flags = window.getAttributes().flags;
        if ((flags & 0x200) != 0) {
            window.clearFlags(512);
        }
        FrameLayout contentView = (FrameLayout)window.findViewById(0x1020002);
        final int[] decorViewInvisibleHeightPre = new int[]{KeyboardUtils.getDecorViewInvisibleHeight(window)};
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = KeyboardUtils.getDecorViewInvisibleHeight(window);
                if (decorViewInvisibleHeightPre[0] != height) {
                    listener.onSoftInputChanged(height);
                    decorViewInvisibleHeightPre[0] = height;
                }
            }
        };
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        contentView.setTag(-8, (Object)onGlobalLayoutListener);
    }

    public static void unregisterSoftInputChangedListener(@NonNull Window window) {
        View contentView = window.findViewById(0x1020002);
        if (contentView == null) {
            return;
        }
        Object tag = contentView.getTag(-8);
        if (tag instanceof ViewTreeObserver.OnGlobalLayoutListener && Build.VERSION.SDK_INT >= 16) {
            contentView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)tag);
        }
    }

    public static void fixAndroidBug5497(@NonNull Activity activity) {
        KeyboardUtils.fixAndroidBug5497(activity.getWindow());
    }

    public static void fixAndroidBug5497(final @NonNull Window window) {
        int softInputMode = window.getAttributes().softInputMode;
        window.setSoftInputMode(softInputMode & 0xFFFFFFEF);
        FrameLayout contentView = (FrameLayout)window.findViewById(0x1020002);
        final View contentViewChild = contentView.getChildAt(0);
        final int paddingBottom = contentViewChild.getPaddingBottom();
        final int[] contentViewInvisibleHeightPre5497 = new int[]{KeyboardUtils.getContentViewInvisibleHeight(window)};
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = KeyboardUtils.getContentViewInvisibleHeight(window);
                if (contentViewInvisibleHeightPre5497[0] != height) {
                    contentViewChild.setPadding(contentViewChild.getPaddingLeft(), contentViewChild.getPaddingTop(), contentViewChild.getPaddingRight(), paddingBottom + KeyboardUtils.getDecorViewInvisibleHeight(window));
                    contentViewInvisibleHeightPre5497[0] = height;
                }
            }
        });
    }

    private static int getContentViewInvisibleHeight(Window window) {
        View contentView = window.findViewById(0x1020002);
        if (contentView == null) {
            return 0;
        }
        Rect outRect = new Rect();
        contentView.getWindowVisibleDisplayFrame(outRect);
        Log.d((String)"KeyboardUtils", (String)("getContentViewInvisibleHeight: " + (contentView.getBottom() - outRect.bottom)));
        int delta = Math.abs(contentView.getBottom() - outRect.bottom);
        if (delta <= UtilsBridge.getStatusBarHeight() + UtilsBridge.getNavBarHeight()) {
            return 0;
        }
        return delta;
    }

    public static void fixSoftInputLeaks(@NonNull Activity activity) {
        KeyboardUtils.fixSoftInputLeaks(activity.getWindow());
    }

    public static void fixSoftInputLeaks(@NonNull Window window) {
        String[] leakViews;
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        for (String leakView : leakViews = new String[]{"mLastSrvView", "mCurRootView", "mServedView", "mNextServedView"}) {
            try {
                View view;
                Object obj;
                Field leakViewField = InputMethodManager.class.getDeclaredField(leakView);
                if (!leakViewField.isAccessible()) {
                    leakViewField.setAccessible(true);
                }
                if (!((obj = leakViewField.get(imm)) instanceof View) || (view = (View)obj).getRootView() != window.getDecorView().getRootView()) continue;
                leakViewField.set(imm, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void clickBlankArea2HideSoftInput() {
        Log.i((String)"KeyboardUtils", (String)"Please refer to the following code.");
    }

    static {
        sDecorViewDelta = 0;
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

