/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.InputAEADDecryptor;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.InputDecryptor;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.MacCalculator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.io.TeeInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class RecipientOperator {
    private final Object operator;

    public RecipientOperator(InputDecryptor inputDecryptor) {
        this.operator = inputDecryptor;
    }

    public RecipientOperator(MacCalculator macCalculator) {
        this.operator = macCalculator;
    }

    public InputStream getInputStream(InputStream inputStream) {
        if (this.operator instanceof InputDecryptor) {
            return ((InputDecryptor)this.operator).getInputStream(inputStream);
        }
        return new TeeInputStream(inputStream, ((MacCalculator)this.operator).getOutputStream());
    }

    public boolean isAEADBased() {
        return this.operator instanceof InputAEADDecryptor;
    }

    public OutputStream getAADStream() {
        return ((InputAEADDecryptor)this.operator).getAADStream();
    }

    public boolean isMacBased() {
        return this.operator instanceof MacCalculator;
    }

    public byte[] getMac() {
        if (this.operator instanceof MacCalculator) {
            return ((MacCalculator)this.operator).getMac();
        }
        if (this.operator instanceof InputAEADDecryptor) {
            return ((InputAEADDecryptor)this.operator).getMAC();
        }
        return null;
    }
}

