/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.asymmetric.ecgost12;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.internal.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PrivateKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PublicKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECCurve;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new ECKeyPairGenerator();
    String algorithm = "ECGOST3410-2012";
    ECKeyGenerationParameters param;
    int strength = 239;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ECGOST3410-2012");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof GOST3410ParameterSpec) {
            GOST3410ParameterSpec gOST3410ParameterSpec = (GOST3410ParameterSpec)algorithmParameterSpec;
            this.init(gOST3410ParameterSpec, secureRandom);
        } else if (algorithmParameterSpec instanceof com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec) {
            com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator());
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec || algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            String string = algorithmParameterSpec instanceof ECGenParameterSpec ? ((ECGenParameterSpec)algorithmParameterSpec).getName() : ((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(string);
            if (aSN1ObjectIdentifier.equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256_paramSetB) || aSN1ObjectIdentifier.equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256_paramSetC) || aSN1ObjectIdentifier.equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256_paramSetD)) {
                this.init(new GOST3410ParameterSpec(ECGOST3410NamedCurves.getOID(string), null), secureRandom);
            } else {
                this.init(new GOST3410ParameterSpec(string), secureRandom);
            }
        } else if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + algorithmParameterSpec.getClass().getName());
        }
    }

    private void init(GOST3410ParameterSpec gOST3410ParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        X9ECParameters x9ECParameters = ECGOST3410NamedCurves.getByOIDX9(gOST3410ParameterSpec.getPublicKeyParamSet());
        if (x9ECParameters == null) {
            throw new InvalidAlgorithmParameterException("unknown curve: " + gOST3410ParameterSpec.getPublicKeyParamSet());
        }
        this.ecParams = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(gOST3410ParameterSpec.getPublicKeyParamSet()), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        this.param = new ECKeyGenerationParameters(new ECGOST3410Parameters(new ECNamedDomainParameters(gOST3410ParameterSpec.getPublicKeyParamSet(), x9ECParameters), gOST3410ParameterSpec.getPublicKeyParamSet(), gOST3410ParameterSpec.getDigestParamSet(), gOST3410ParameterSpec.getEncryptionParamSet()), secureRandom);
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        if (this.ecParams instanceof com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec) {
            com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (com.bmuschko.gradle.docker.shaded.org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
            BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey = new BCECGOST3410_2012PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
            return new KeyPair(bCECGOST3410_2012PublicKey, new BCECGOST3410_2012PrivateKey(this.algorithm, eCPrivateKeyParameters, bCECGOST3410_2012PublicKey, eCParameterSpec));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCECGOST3410_2012PublicKey(this.algorithm, eCPublicKeyParameters), new BCECGOST3410_2012PrivateKey(this.algorithm, eCPrivateKeyParameters));
        }
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
        BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey = new BCECGOST3410_2012PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
        return new KeyPair(bCECGOST3410_2012PublicKey, new BCECGOST3410_2012PrivateKey(this.algorithm, eCPrivateKeyParameters, bCECGOST3410_2012PublicKey, eCParameterSpec));
    }
}

