/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ieee1609dot2dot1;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1IA5String;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Object;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Sequence;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.DERIA5String;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.OEROptional;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ItsUtils;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Time32;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.oer.its.ieee1609dot2.basetypes.UINT8;

public class EeEcaCertRequest
extends ASN1Object {
    private final UINT8 version;
    private final Time32 generationTime;
    private final CertificateType type;
    private final ToBeSignedCertificate tbsCert;
    private final ASN1IA5String canonicalId;

    public EeEcaCertRequest(UINT8 uINT8, Time32 time32, CertificateType certificateType, ToBeSignedCertificate toBeSignedCertificate, ASN1IA5String aSN1IA5String) {
        this.version = uINT8;
        this.generationTime = time32;
        this.type = certificateType;
        this.tbsCert = toBeSignedCertificate;
        this.canonicalId = aSN1IA5String;
    }

    private EeEcaCertRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 5) {
            throw new IllegalArgumentException("expected sequence size of 5");
        }
        this.version = UINT8.getInstance(aSN1Sequence.getObjectAt(0));
        this.generationTime = Time32.getInstance(aSN1Sequence.getObjectAt(1));
        this.type = CertificateType.getInstance(aSN1Sequence.getObjectAt(2));
        this.tbsCert = ToBeSignedCertificate.getInstance(aSN1Sequence.getObjectAt(3));
        this.canonicalId = OEROptional.getInstance(aSN1Sequence.getObjectAt(4)).getObject(ASN1IA5String.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EeEcaCertRequest getInstance(Object object) {
        if (object instanceof EeEcaCertRequest) {
            return (EeEcaCertRequest)object;
        }
        if (object != null) {
            return new EeEcaCertRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ItsUtils.toSequence(this.version, this.generationTime, this.type, this.tbsCert, OEROptional.getInstance(this.canonicalId));
    }

    public UINT8 getVersion() {
        return this.version;
    }

    public Time32 getGenerationTime() {
        return this.generationTime;
    }

    public CertificateType getType() {
        return this.type;
    }

    public ToBeSignedCertificate getTbsCert() {
        return this.tbsCert;
    }

    public ASN1IA5String getCanonicalId() {
        return this.canonicalId;
    }

    public static class Builder {
        private UINT8 version;
        private Time32 generationTime;
        private CertificateType type;
        private ToBeSignedCertificate tbsCert;
        private DERIA5String canonicalId;

        public Builder setVersion(UINT8 uINT8) {
            this.version = uINT8;
            return this;
        }

        public Builder setGenerationTime(Time32 time32) {
            this.generationTime = time32;
            return this;
        }

        public Builder setType(CertificateType certificateType) {
            this.type = certificateType;
            return this;
        }

        public Builder setTbsCert(ToBeSignedCertificate toBeSignedCertificate) {
            this.tbsCert = toBeSignedCertificate;
            return this;
        }

        public Builder setCanonicalId(DERIA5String dERIA5String) {
            this.canonicalId = dERIA5String;
            return this;
        }

        public Builder setCanonicalId(String string) {
            this.canonicalId = new DERIA5String(string);
            return this;
        }

        public EeEcaCertRequest createEeEcaCertRequest() {
            return new EeEcaCertRequest(this.version, this.generationTime, this.type, this.tbsCert, this.canonicalId);
        }
    }
}

