/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.jcajce.provider.mayo;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Set;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.mayo.MayoPrivateKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.jcajce.interfaces.MayoKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.jcajce.spec.MayoParameterSpec;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.Arrays;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCMayoPrivateKey
implements PrivateKey,
MayoKey {
    private static final long serialVersionUID = 1L;
    private transient MayoPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCMayoPrivateKey(MayoPrivateKeyParameters mayoPrivateKeyParameters) {
        this.params = mayoPrivateKeyParameters;
    }

    public BCMayoPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (MayoPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCMayoPrivateKey) {
            BCMayoPrivateKey bCMayoPrivateKey = (BCMayoPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCMayoPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public MayoParameterSpec getParameterSpec() {
        return MayoParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    MayoPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

