/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerRemoveContainer
extends DockerExistingContainer {
    private final Property<Boolean> removeVolumes = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> force = this.getProject().getObjects().property(Boolean.class);

    @Input
    @Optional
    public final Property<Boolean> getRemoveVolumes() {
        return this.removeVolumes;
    }

    @Input
    @Optional
    public final Property<Boolean> getForce() {
        return this.force;
    }

    @Override
    public void runRemoteCommand() {
        RemoveContainerCmd containerCommand = this.getDockerClient().removeContainerCmd((String)this.getContainerId().get());
        this.configureContainerCommandConfig(containerCommand);
        this.getLogger().quiet("Removing container with ID '" + (String)this.getContainerId().get() + "'.");
        containerCommand.exec();
    }

    private void configureContainerCommandConfig(RemoveContainerCmd containerCommand) {
        if (Boolean.TRUE.equals(this.removeVolumes.getOrNull())) {
            containerCommand.withRemoveVolumes((Boolean)this.removeVolumes.get());
        }
        if (Boolean.TRUE.equals(this.force.getOrNull())) {
            containerCommand.withForce((Boolean)this.force.get());
        }
    }
}

