/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

class IntegerParser {
    private int pos;
    private long value;

    IntegerParser(long value, int pos) {
        this.value = value;
        this.pos = pos;
    }

    int getEndPos() {
        return this.pos;
    }

    static IntegerParser parseInt(String input, int startpos, int len, boolean includeSign) {
        char ch;
        int pos = startpos;
        boolean isNegative = false;
        long value = 0L;
        if (pos >= len) {
            return null;
        }
        if (includeSign) {
            ch = input.charAt(pos);
            switch (ch) {
                case '-': {
                    isNegative = true;
                }
                case '+': {
                    ++pos;
                }
            }
        }
        int sigStart = pos;
        while (pos < len && (ch = input.charAt(pos)) >= '0' && ch <= '9') {
            if (isNegative ? (value = value * 10L - (long)(ch - 48)) < Integer.MIN_VALUE : (value = value * 10L + (long)(ch - 48)) > Integer.MAX_VALUE) {
                return null;
            }
            ++pos;
        }
        if (pos == sigStart) {
            return null;
        }
        return new IntegerParser(value, pos);
    }

    public int value() {
        return (int)this.value;
    }

    static IntegerParser parseHex(String input, int startpos, int len) {
        int pos;
        long value = 0L;
        if (pos >= len) {
            return null;
        }
        for (pos = startpos; pos < len; ++pos) {
            char ch = input.charAt(pos);
            if (ch >= '0' && ch <= '9') {
                value = value * 16L + (long)(ch - 48);
            } else if (ch >= 'A' && ch <= 'F') {
                value = value * 16L + (long)(ch - 65) + 10L;
            } else {
                if (ch < 'a' || ch > 'f') break;
                value = value * 16L + (long)(ch - 97) + 10L;
            }
            if (value <= 0xFFFFFFFFL) continue;
            return null;
        }
        if (pos == startpos) {
            return null;
        }
        return new IntegerParser(value, pos);
    }
}

